/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageStorageInteraction;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageStorageInteractionC;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TraderStorageMenu
extends AbstractContainerMenu
implements ITraderStorageMenu {
    public final Supplier<ITrader> traderSource;
    public final Player player;
    public static final int SLOT_OFFSET = 15;
    Container coinSlotContainer = new SimpleContainer(5);
    List<CoinSlot> coinSlots = new ArrayList<CoinSlot>();
    private boolean canEditTabs = true;
    Map<Integer, TraderStorageTab> availableTabs = new HashMap<Integer, TraderStorageTab>();
    int currentTab = 0;
    private List<Consumer<CompoundTag>> listeners = new ArrayList<Consumer<CompoundTag>>();

    public final ITrader getTrader() {
        return this.traderSource.get();
    }

    public List<CoinSlot> getCoinSlots() {
        return this.coinSlots;
    }

    public boolean coinSlotsActive() {
        return this.coinSlots.get(0).m_6659_();
    }

    public Map<Integer, TraderStorageTab> getAllTabs() {
        return this.availableTabs;
    }

    public void setTab(int key, TraderStorageTab tab) {
        if (this.canEditTabs && tab != null) {
            this.availableTabs.put(key, tab);
        } else if (tab == null) {
            LightmansCurrency.LogError("Attempted to set a null storage tab in slot " + key);
        } else {
            LightmansCurrency.LogError("Attempted to define the tab in " + key + " but the tabs have been locked.");
        }
    }

    public int getCurrentTabIndex() {
        return this.currentTab;
    }

    public TraderStorageTab getCurrentTab() {
        return this.availableTabs.get(this.currentTab);
    }

    public TradeContext getContext() {
        return TradeContext.createStorageMode(this.traderSource.get());
    }

    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    public TraderStorageMenu(int windowID, Inventory inventory, BlockPos traderPos) {
        this(ModMenus.TRADER_STORAGE, windowID, inventory, () -> {
            BlockEntity be = inventory.f_35978_.f_19853_.m_7702_(traderPos);
            if (be instanceof ITrader) {
                return (ITrader)be;
            }
            return null;
        });
    }

    protected TraderStorageMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<ITrader> traderSource) {
        super(type, windowID);
        int x;
        this.traderSource = traderSource;
        this.player = inventory.f_35978_;
        ITrader trader = this.traderSource.get();
        this.setTab(0, new BasicTradeEditTab(this));
        if (trader != null) {
            trader.initStorageTabs(this);
        }
        this.canEditTabs = false;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coinSlotContainer.m_6643_(); ++x) {
            CoinSlot newSlot = new CoinSlot(this.coinSlotContainer, x, 23 + (x + 4) * 18, 122);
            this.coinSlots.add(newSlot);
            this.m_38897_(newSlot);
        }
        this.availableTabs.forEach((key, tab) -> tab.addStorageMenuSlots(x$0 -> this.m_38897_((Slot)x$0)));
        try {
            this.getCurrentTab().onTabOpen();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.getTrader().userOpen(this.player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.coinSlotContainer);
        this.availableTabs.forEach((key, tab) -> tab.onMenuClose());
        ITrader trader = this.getTrader();
        if (trader != null) {
            trader.userClose(player);
        }
    }

    public void clearContainer(Container container) {
        this.m_150411_(this.player, container);
    }

    public boolean m_6875_(Player player) {
        return this.traderSource != null && this.traderSource.get() != null && this.traderSource.get().hasPermission(player, "openStorage");
    }

    public void validateCoinSlots() {
        boolean canAddCoins = this.hasCoinSlotAccess();
        for (CoinSlot slot : this.coinSlots) {
            slot.active = canAddCoins;
        }
    }

    private boolean hasCoinSlotAccess() {
        ITrader trader = this.getTrader();
        return trader == null ? false : trader.hasPermission(this.player, "storeCoins");
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.getCurrentTab().quickMoveStack(slotStack) && (this.hasCoinSlotAccess() ? !this.m_38903_(slotStack, 36, 36 + this.coinSlots.size(), false) && !this.m_38903_(slotStack, 36 + this.coinSlots.size(), this.f_38839_.size(), false) : !this.m_38903_(slotStack, 36 + this.coinSlots.size(), this.f_38839_.size(), false)) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean hasPermission(String permission) {
        ITrader trader = this.getTrader();
        if (trader != null) {
            return trader.hasPermission(this.player, permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        ITrader trader = this.getTrader();
        if (trader != null) {
            return trader.getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    public void changeTab(int key) {
        if (this.currentTab == key) {
            return;
        }
        if (this.availableTabs.containsKey(key)) {
            if (this.availableTabs.get(key).canOpen(this.player)) {
                this.getCurrentTab().onTabClose();
                this.currentTab = key;
                this.getCurrentTab().onTabOpen();
            }
        } else {
            LightmansCurrency.LogWarning("Trader Storage Menu doesn't have a tab defined for " + key);
        }
    }

    public CompoundTag createTabChangeMessage(int newTab, @Nullable CompoundTag extraData) {
        CompoundTag message = extraData == null ? new CompoundTag() : extraData;
        message.m_128405_("ChangeTab", newTab);
        return message;
    }

    public CompoundTag createCoinSlotActiveMessage(boolean nowActive, @Nullable CompoundTag extraData) {
        CompoundTag message = extraData == null ? new CompoundTag() : extraData;
        message.m_128379_("SetCoinSlotsActive", nowActive);
        return message;
    }

    public void sendMessage(CompoundTag message) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageStorageInteraction(message));
        } else {
            LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(this.player), (Object)new MessageStorageInteractionC(message));
        }
    }

    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("ChangeTab", 3)) {
            this.changeTab(message.m_128451_("ChangeTab"));
        }
        if (message.m_128441_("SetCoinSlotsActive")) {
            SimpleSlot.SetActive(this.coinSlots, message.m_128471_("SetCoinSlotsActive"));
        }
        try {
            this.getCurrentTab().receiveMessage(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Consumer<CompoundTag> listener : this.listeners) {
            try {
                listener.accept(message);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addMessageListener(Consumer<CompoundTag> listener) {
        if (!this.listeners.contains(listener) && listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean HasCoinsToAdd() {
        return MoneyUtil.getValue(this.coinSlotContainer) > 0L;
    }

    @Override
    public void CollectCoinStorage() {
        ITrader trader = this.getTrader();
        if (trader == null) {
            this.player.m_6915_();
            return;
        }
        if (trader.hasPermission(this.player, "collectCoins")) {
            TradeContext tempContext;
            CoinValue storedMoney = trader.getInternalStoredMoney();
            if (storedMoney.getRawValue() > 0L && (tempContext = TradeContext.create(trader, this.player).withCoinSlots(this.coinSlotContainer).build()).givePayment(storedMoney)) {
                trader.clearStoredMoney();
            }
        } else {
            Settings.PermissionWarning(this.player, "collect stored coins", "collectCoins");
        }
    }

    @Override
    public void AddCoins() {
        ITrader trader = this.getTrader();
        if (trader == null) {
            this.player.m_6915_();
            return;
        }
        if (trader.hasPermission(this.player, "storeCoins")) {
            CoinValue addAmount = CoinValue.easyBuild2(this.coinSlotContainer);
            trader.addStoredMoney(addAmount);
            this.coinSlotContainer.m_6211_();
        } else {
            Settings.PermissionWarning(this.player, "store coins", "storeCoins");
        }
    }

    public static class TraderStorageMenuUniversal
    extends TraderStorageMenu {
        public TraderStorageMenuUniversal(int windowID, Inventory inventory, UUID traderID) {
            super(ModMenus.TRADER_STORAGE_UNIVERSAL, windowID, inventory, () -> {
                if (inventory.f_35978_.f_19853_.f_46443_) {
                    return ClientTradingOffice.getData(traderID);
                }
                return TradingOffice.getData(traderID);
            });
        }
    }

    public static interface IClientMessage {
        public void selfMessage(CompoundTag var1);
    }
}

