/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.slots;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class CoinSlot
extends SimpleSlot {
    public static final ResourceLocation EMPTY_COIN_SLOT = new ResourceLocation("lightmanscurrency", "items/empty_coin_slot");
    private boolean acceptHiddenCoins;
    private boolean lockInput = false;
    private boolean lockOutput = false;
    private List<ICoinSlotListener> listeners = Lists.newArrayList();

    public void LockInput() {
        this.lockInput = true;
    }

    public void UnlockInput() {
        this.lockInput = false;
    }

    public void LockOutput() {
        this.lockOutput = true;
    }

    public void UnlockOutput() {
        this.lockOutput = false;
    }

    public void Lock() {
        this.lockOutput = true;
        this.lockInput = true;
    }

    public void Unlock() {
        this.lockOutput = false;
        this.lockInput = false;
    }

    public CoinSlot(Container inventory, int index, int x, int y) {
        this(inventory, index, x, y, true);
    }

    public CoinSlot(Container inventory, int index, int x, int y, boolean acceptHiddenCoins) {
        super(inventory, index, x, y);
        this.acceptHiddenCoins = acceptHiddenCoins;
    }

    public CoinSlot addListener(ICoinSlotListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        if (this.lockInput) {
            return false;
        }
        if (this.acceptHiddenCoins) {
            return MoneyUtil.isCoin(stack.m_41720_());
        }
        return MoneyUtil.isCoin(stack.m_41720_()) && !MoneyUtil.isCoinHidden(stack.m_41720_());
    }

    public void m_5852_(ItemStack stack) {
        if (this.lockInput && !stack.m_41619_()) {
            return;
        }
        super.m_5852_(stack);
    }

    @Override
    public ItemStack m_6201_(int amount) {
        if (this.lockOutput) {
            return ItemStack.f_41583_;
        }
        return super.m_6201_(amount);
    }

    @Override
    public boolean m_8010_(Player player) {
        if (this.lockOutput) {
            return false;
        }
        return super.m_8010_(player);
    }

    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_COIN_SLOT);
    }

    public void m_6654_() {
        super.m_6654_();
        this.listeners.forEach(listener -> listener.onCoinSlotChanged());
    }

    public static interface ICoinSlotListener {
        public void onCoinSlotChanged();
    }
}

