/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageSubmitBid {
    final UUID auctionHouseID;
    final int tradeIndex;
    final CoinValue bidAmount;

    public MessageSubmitBid(UUID auctionHouseID, int tradeIndex, CoinValue bidAmount) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    public static void encode(MessageSubmitBid message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.auctionHouseID);
        buffer.writeInt(message.tradeIndex);
        buffer.m_130079_(message.bidAmount.writeToNBT(new CompoundTag(), "CoinValue"));
    }

    public static MessageSubmitBid decode(FriendlyByteBuf buffer) {
        return new MessageSubmitBid(buffer.m_130259_(), buffer.readInt(), new CoinValue(buffer.m_130261_()));
    }

    public static void handle(MessageSubmitBid message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.f_36096_ instanceof TraderMenu) {
                TraderMenu menu = (TraderMenu)player.f_36096_;
                UniversalTraderData data = TradingOffice.getData(message.auctionHouseID);
                if (data instanceof AuctionHouseTrader) {
                    AuctionHouseTrader ah = (AuctionHouseTrader)data;
                    ah.makeBid((Player)player, menu, message.tradeIndex, message.bidAmount);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

