/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferResponse;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankTransferTeam {
    UUID teamID;
    CoinValue amount;

    public MessageBankTransferTeam(UUID teamID, CoinValue amount) {
        this.teamID = teamID;
        this.amount = amount;
    }

    public static void encode(MessageBankTransferTeam message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.teamID);
        buffer.m_130079_(message.amount.writeToNBT(new CompoundTag(), "CoinValue"));
    }

    public static MessageBankTransferTeam decode(FriendlyByteBuf buffer) {
        return new MessageBankTransferTeam(buffer.m_130259_(), new CoinValue(buffer.m_130261_()));
    }

    public static void handle(MessageBankTransferTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BankAccount.AccountReference destination;
            BankAccount.IBankAccountAdvancedMenu menu;
            MutableComponent response;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.f_36096_ instanceof BankAccount.IBankAccountAdvancedMenu && (response = BankAccount.TransferCoins(menu = (BankAccount.IBankAccountAdvancedMenu)player.f_36096_, message.amount, destination = BankAccount.GenerateReference(false, BankAccount.AccountType.Team, message.teamID))) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageBankTransferResponse(response));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

