/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CPacketWalletInteraction {
    int clickedSlot;
    boolean heldShift;
    ItemStack heldStack;

    public CPacketWalletInteraction(int clickedSlot, boolean heldShift, ItemStack heldStack) {
        this.clickedSlot = clickedSlot;
        this.heldShift = heldShift;
        this.heldStack = heldStack;
    }

    public static void encode(CPacketWalletInteraction message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.clickedSlot);
        buffer.writeBoolean(message.heldShift);
        buffer.writeItemStack(message.heldStack, false);
    }

    public static CPacketWalletInteraction decode(FriendlyByteBuf buffer) {
        return new CPacketWalletInteraction(buffer.readInt(), buffer.readBoolean(), buffer.m_130267_());
    }

    public static void handle(CPacketWalletInteraction message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                WalletCapability.WalletSlotInteraction((Player)player, message.clickedSlot, message.heldShift, message.heldStack);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

