/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.permissions;

import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class PermissionsList {
    private final HashMap<String, Integer> permissions = Maps.newHashMap();
    private final ITrader trader;
    private final String updateType;

    public PermissionsList(ITrader trader, String updateType) {
        this.trader = trader;
        this.updateType = updateType;
    }

    public PermissionsList(ITrader trader, String updateType, Map<String, Integer> permissions) {
        this(trader, updateType);
        permissions.forEach((permission, level) -> this.setLevel((String)permission, (int)level));
    }

    public int getLevel(String permission) {
        if (this.permissions.containsKey(permission)) {
            return this.permissions.get(permission);
        }
        return 0;
    }

    public CompoundTag changeLevel(Player requestor, String permission, int level) {
        if (!this.trader.hasPermission(requestor, "editPermissions")) {
            Settings.PermissionWarning(requestor, "edit permissions", "editPermissions");
            return null;
        }
        this.setLevel(permission, level);
        CompoundTag updateInfo = Settings.initUpdateInfo(this.updateType);
        updateInfo.m_128359_("permission", permission);
        updateInfo.m_128405_("level", this.getLevel(permission));
        return updateInfo;
    }

    public boolean changeLevel(Player requestor, CompoundTag updateInfo) {
        if (!this.trader.hasPermission(requestor, "editPermissions")) {
            Settings.PermissionWarning(requestor, "edit permissions", "editPermissions");
            return false;
        }
        String permission = updateInfo.m_128461_("permission");
        int level = updateInfo.m_128451_("level");
        if (level == this.getLevel(permission)) {
            return false;
        }
        int oldLevel = this.getLevel(permission);
        this.setLevel(permission, level);
        this.trader.getCoreSettings().getLogger().LogSettingsChange(requestor, this.updateType + "." + permission, oldLevel, this.getLevel(permission));
        return true;
    }

    private void setLevel(String permission, int level) {
        if (level <= 0) {
            this.resetLevel(permission);
        } else {
            this.permissions.put(permission, level);
        }
    }

    private void resetLevel(String permission) {
        if (this.permissions.containsKey(permission)) {
            this.permissions.remove(permission);
        }
    }

    public void save(CompoundTag compound, String tag) {
        ListTag list = new ListTag();
        this.permissions.forEach((permission, level) -> {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("permission", permission);
            thisCompound.m_128405_("level", level.intValue());
            list.add((Object)thisCompound);
        });
        compound.m_128365_(tag, (Tag)list);
    }

    public static PermissionsList load(ITrader trader, String updateType, CompoundTag compound, String tag) {
        PermissionsList result = new PermissionsList(trader, updateType);
        if (compound.m_128425_(tag, 9)) {
            ListTag list = compound.m_128437_(tag, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag thisCompound = list.m_128728_(i);
                String permission = thisCompound.m_128461_("permission");
                int level = thisCompound.m_128451_("level");
                result.setLevel(permission, level);
            }
        }
        return result;
    }
}

