/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerReference {
    private static Map<UUID, PlayerReference> knownReferences = new HashMap<UUID, PlayerReference>();
    public final UUID id;
    private String name = "";

    public static void clearPlayerCache() {
        knownReferences.clear();
    }

    public static List<PlayerReference> getKnownPlayers() {
        return knownReferences.values().stream().collect(Collectors.toList());
    }

    public String lastKnownName() {
        return this.name;
    }

    public MutableComponent lastKnownNameComponent() {
        return new TextComponent(this.name);
    }

    private PlayerReference(UUID playerID, String name) {
        this.id = playerID;
        this.name = name;
    }

    @Deprecated
    public void tryUpdateName(Player player) {
        if (this.is((Entity)player)) {
            this.name = player.m_36316_().getName();
        }
    }

    public PlayerReference copyWithName(String name) {
        return new PlayerReference(this.id, name);
    }

    public boolean is(PlayerReference player) {
        if (player == null) {
            return false;
        }
        return this.is(player.id);
    }

    public boolean is(GameProfile profile) {
        return this.is(profile.getId());
    }

    public boolean is(UUID entityID) {
        if (entityID == null) {
            return false;
        }
        return entityID.equals(this.id);
    }

    public boolean is(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_142081_().equals(this.id);
    }

    public boolean is(String name) {
        return this.name.toLowerCase().contentEquals(name.toLowerCase());
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public Player getPlayer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_6846_().m_11259_(this.id);
        }
        return null;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("id", this.id);
        compound.m_128359_("name", this.name);
        return compound;
    }

    public JsonObject saveAsJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        json.addProperty("name", this.name);
        return json;
    }

    public static PlayerReference load(CompoundTag compound) {
        try {
            UUID id = compound.m_128342_("id");
            String name = compound.m_128461_("name");
            return PlayerReference.of(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from tag.", e.getMessage());
            return null;
        }
    }

    public static PlayerReference load(JsonElement json) {
        try {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return PlayerReference.of(json.getAsString());
            }
            JsonObject j = json.getAsJsonObject();
            UUID id = UUID.fromString(j.get("id").getAsString());
            String name = j.get("name").getAsString();
            return PlayerReference.of(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from JsonObject", e);
            return null;
        }
    }

    public static void saveList(CompoundTag compound, List<PlayerReference> playerList, String tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag thisCompound = playerList.get(i).save();
            list.add((Object)thisCompound);
        }
        compound.m_128365_(tag, (Tag)list);
    }

    public static List<PlayerReference> loadList(CompoundTag compound, String tag) {
        ArrayList playerList = Lists.newArrayList();
        ListTag list = compound.m_128437_(tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag thisCompound = list.m_128728_(i);
            PlayerReference player = PlayerReference.load(thisCompound);
            if (player == null) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static PlayerReference of(UUID playerID, String name) {
        return PlayerReference.of(playerID, name, false);
    }

    public static PlayerReference of(UUID playerID, String name, boolean isTrueName) {
        MinecraftServer server;
        if (playerID == null) {
            return null;
        }
        if (!isTrueName && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            GameProfile profile = server.m_129927_().m_11002_(playerID).orElse(null);
            if (profile == null || profile.getName() == null) {
                return null;
            }
            name = profile.getName();
            isTrueName = true;
        }
        if (knownReferences.containsKey(playerID)) {
            PlayerReference pr = knownReferences.get(playerID);
            if (isTrueName) {
                pr.name = name;
            }
            return pr;
        }
        PlayerReference newPR = new PlayerReference(playerID, name);
        knownReferences.put(playerID, newPR);
        return newPR;
    }

    public static PlayerReference of(GameProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        return PlayerReference.of(playerProfile.getId(), playerProfile.getName(), true);
    }

    public static PlayerReference of(Entity entity) {
        if (entity instanceof Player) {
            return PlayerReference.of((Player)entity);
        }
        return null;
    }

    public static PlayerReference of(Player player) {
        if (player == null) {
            return null;
        }
        return PlayerReference.of(player.m_36316_());
    }

    public static PlayerReference of(String playerName) {
        if (playerName.isBlank()) {
            return null;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return PlayerReference.of(server.m_129927_().m_10996_(playerName).orElse(null));
        }
        return null;
    }

    public static boolean listContains(List<PlayerReference> list, UUID id) {
        for (PlayerReference player : list) {
            if (!player.is(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean listContains(List<PlayerReference> list, String name) {
        for (PlayerReference player : list) {
            if (!player.is(name)) continue;
            return true;
        }
        return false;
    }

    public static void removeFromList(List<PlayerReference> list, UUID id) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).is(id)) continue;
            list.remove(i);
            return;
        }
    }

    public static void removeFromList(List<PlayerReference> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).is(name)) continue;
            list.remove(i);
            return;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

