/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class AuctionTradeData
extends TradeData {
    public static final long MINIMUM_DURATION = 3600000L;
    public static final long DEFAULT_DURATION = 86400000L;
    private boolean cancelled;
    private String persistentID = "";
    CoinValue lastBidAmount = new CoinValue(new CoinValue.CoinValuePair[0]);
    PlayerReference lastBidPlayer = null;
    CoinValue minBidDifference = new CoinValue(1L);
    PlayerReference tradeOwner;
    long startTime = 0L;
    long duration = 0L;
    List<ItemStack> auctionItems = new ArrayList<ItemStack>();

    public boolean hasBid() {
        return this.lastBidPlayer != null;
    }

    public boolean isPersistentID(String id) {
        return this.persistentID.equals(id);
    }

    public CoinValue getLastBidAmount() {
        return this.lastBidAmount;
    }

    public PlayerReference getLastBidPlayer() {
        return this.lastBidPlayer;
    }

    public void setStartingBid(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.lastBidAmount = amount.copy();
    }

    public CoinValue getMinBidDifference() {
        return this.minBidDifference;
    }

    public void setMinBidDifferent(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.minBidDifference = amount.copy();
        if (this.minBidDifference.getRawValue() <= 0L) {
            this.minBidDifference = new CoinValue(1L);
        }
    }

    public boolean isOwner(Player player) {
        return this.tradeOwner != null && this.tradeOwner.is((Entity)player) || TradingOffice.isAdminPlayer(player);
    }

    public void setDuration(long duration) {
        if (this.isActive()) {
            return;
        }
        this.duration = Math.max(3600000L, duration);
    }

    public List<ItemStack> getAuctionItems() {
        return this.auctionItems;
    }

    public void setAuctionItems(Container auctionItems) {
        if (this.isActive()) {
            return;
        }
        this.auctionItems.clear();
        for (int i = 0; i < auctionItems.m_6643_(); ++i) {
            ItemStack stack = auctionItems.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack.m_41777_());
        }
    }

    public AuctionTradeData(Player owner) {
        this.tradeOwner = PlayerReference.of(owner);
        this.setDuration(86400000L);
    }

    public AuctionTradeData(CompoundTag compound) {
        this.loadFromNBT(compound);
    }

    public AuctionTradeData(PersistentAuctionData data) {
        this.persistentID = data.id;
        this.setDuration(data.duration);
        this.auctionItems = data.getAuctionItems();
        this.setStartingBid(data.getStartingBid());
        this.setMinBidDifferent(data.getMinimumBidDifference());
    }

    public boolean isActive() {
        return this.startTime != 0L && !this.cancelled;
    }

    @Override
    public boolean isValid() {
        if (this.cancelled) {
            return false;
        }
        if (this.auctionItems.size() <= 0) {
            return false;
        }
        if (this.isActive() && this.hasExpired(TimeUtil.getCurrentTime())) {
            return false;
        }
        if (this.minBidDifference.getRawValue() <= 0L) {
            return false;
        }
        return this.lastBidAmount.getRawValue() > 0L;
    }

    public void startTimer() {
        if (!this.isActive()) {
            this.startTime = TimeUtil.getCurrentTime();
        }
    }

    public long getRemainingTime(long currentTime) {
        if (!this.isActive()) {
            return this.duration;
        }
        return Math.max(0L, this.startTime + this.duration - currentTime);
    }

    public boolean hasExpired(long time) {
        if (this.isActive()) {
            return time >= this.startTime + this.duration;
        }
        return false;
    }

    public boolean tryMakeBid(AuctionHouseTrader trader, Player player, CoinValue amount) {
        if (!this.validateBidAmount(amount)) {
            return false;
        }
        PlayerReference oldBidder = this.lastBidPlayer;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage storage = trader.getStorage(this.lastBidPlayer);
            storage.giveMoney(this.lastBidAmount);
            trader.markStorageDirty();
        }
        this.lastBidPlayer = PlayerReference.of(player);
        this.lastBidAmount = amount.copy();
        if (oldBidder != null) {
            TradingOffice.pushNotification(oldBidder.id, new AuctionHouseBidNotification(this));
        }
        return true;
    }

    public boolean validateBidAmount(CoinValue amount) {
        CoinValue minAmount = this.getMinNextBid();
        return amount.getRawValue() >= minAmount.getRawValue();
    }

    public CoinValue getMinNextBid() {
        return new CoinValue(this.lastBidPlayer == null ? this.lastBidAmount.getRawValue() : this.lastBidAmount.getRawValue() + this.minBidDifference.getRawValue());
    }

    public void ExecuteTrade(AuctionHouseTrader trader) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            for (int i = 0; i < this.auctionItems.size(); ++i) {
                buyerStorage.giveItem(this.auctionItems.get(i));
            }
            if (this.tradeOwner != null) {
                AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
                sellerStorage.giveMoney(this.lastBidAmount);
            }
            TradingOffice.pushNotification(this.lastBidPlayer.id, new AuctionHouseBuyerNotification(this));
            if (this.tradeOwner != null) {
                TradingOffice.pushNotification(this.tradeOwner.id, new AuctionHouseSellerNotification(this));
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            for (int i = 0; i < this.auctionItems.size(); ++i) {
                sellerStorage.giveItem(this.auctionItems.get(i));
            }
            TradingOffice.pushNotification(this.tradeOwner.id, new AuctionHouseSellerNobidNotification(this));
        }
    }

    public void CancelTrade(AuctionHouseTrader trader, boolean giveToPlayer, Player player) {
        block5: {
            block4: {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                if (this.lastBidPlayer != null) {
                    AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
                    buyerStorage.giveMoney(this.lastBidAmount);
                    TradingOffice.pushNotification(this.lastBidPlayer.id, new AuctionHouseCancelNotification(this));
                }
                if (!giveToPlayer) break block4;
                for (ItemStack stack : this.auctionItems) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                }
                break block5;
            }
            if (this.tradeOwner == null) break block5;
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner != null ? this.tradeOwner : PlayerReference.of(player));
            for (ItemStack stack : this.auctionItems) {
                sellerStorage.giveItem(stack);
            }
        }
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = new ListTag();
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            itemList.add((Object)this.auctionItems.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128365_("SellItems", (Tag)itemList);
        this.lastBidAmount.writeToNBT(compound, "LastBid");
        if (this.lastBidPlayer != null) {
            compound.m_128365_("LastBidPlayer", (Tag)this.lastBidPlayer.save());
        }
        this.minBidDifference.writeToNBT(compound, "MinBid");
        compound.m_128356_("StartTime", this.startTime);
        compound.m_128356_("Duration", this.duration);
        if (this.tradeOwner != null) {
            compound.m_128365_("TradeOwner", (Tag)this.tradeOwner.save());
        }
        compound.m_128379_("Cancelled", this.cancelled);
        if (!this.persistentID.isBlank()) {
            compound.m_128359_("PersistentID", this.persistentID);
        }
        return compound;
    }

    @Override
    public void loadFromNBT(CompoundTag compound) {
        ListTag itemList = compound.m_128437_("SellItems", 10);
        this.auctionItems.clear();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack);
        }
        this.lastBidAmount.readFromNBT(compound, "LastBid");
        this.lastBidPlayer = compound.m_128441_("LastBidPlayer") ? PlayerReference.load(compound.m_128469_("LastBidPlayer")) : null;
        this.minBidDifference.readFromNBT(compound, "MinBid");
        this.startTime = compound.m_128454_("StartTime");
        this.duration = compound.m_128454_("Duration");
        if (compound.m_128425_("TradeOwner", 10)) {
            this.tradeOwner = PlayerReference.load(compound.m_128469_("TradeOwner"));
        }
        this.cancelled = compound.m_128471_("Cancelled");
        if (compound.m_128425_("PersistentID", 8)) {
            this.persistentID = compound.m_128461_("PersistentID");
        }
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public int tradeButtonHeight(TradeContext context) {
        return 28;
    }

    @Override
    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, 34, 16);
    }

    @Override
    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(58, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(this.lastBidAmount, this.getBidInfo(), true)});
    }

    private List<Component> getBidInfo() {
        ArrayList<Component> bidInfo = new ArrayList<Component>();
        if (this.lastBidPlayer == null) {
            bidInfo.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.nobidder"));
            bidInfo.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.minbid", new Object[]{this.lastBidAmount.getString()}));
        } else {
            bidInfo.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.lastbidder", new Object[]{this.lastBidPlayer.lastKnownName()}));
            bidInfo.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.currentbid", new Object[]{this.lastBidAmount.getString()}));
            bidInfo.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.minbid", new Object[]{this.getMinNextBid().getString()}));
        }
        return bidInfo;
    }

    @Override
    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        ArrayList<TradeButton.DisplayEntry> entries = new ArrayList<TradeButton.DisplayEntry>();
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            ItemStack item = this.auctionItems.get(i);
            if (item.m_41619_()) continue;
            entries.add(TradeButton.DisplayEntry.of(item, item.m_41613_(), ItemRenderUtil.getTooltipFromItem(item)));
        }
        return entries;
    }

    @Override
    public List<AlertData> getAlertData(TradeContext context) {
        return new ArrayList<AlertData>();
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, ItemStack heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    private void openCancelAuctionTab(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler) {
        ITrader t = tab.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            int tradeIndex = trader.getTradeIndex(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAdditional(AbstractWidget button, PoseStack pose, int mouseX, int mouseY, TradeContext context) {
        TimeUtil.TimeData time = TimeUtil.separateDuration(this.getRemainingTime(TimeUtil.getCurrentTime()));
        TextRenderUtil.drawCenteredText(pose, time.toString(), button.f_93620_ + button.m_5711_() / 2, button.f_93621_ + button.m_93694_() - 9, this.getTextColor(time));
    }

    private int getTextColor(TimeUtil.TimeData remainingTime) {
        if (remainingTime.hours < 1L) {
            if (remainingTime.minutes < 5L) {
                return 0xFF0000;
            }
            return 0xFFFF00;
        }
        return 65280;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.NONE;
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        return new TradeData.TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        return new ArrayList<Component>();
    }
}

