/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public interface ITradeRuleHandler {
    public void beforeTrade(TradeEvent.PreTradeEvent var1);

    public void tradeCost(TradeEvent.TradeCostEvent var1);

    public void afterTrade(TradeEvent.PostTradeEvent var1);

    default public boolean allowRule(TradeRule rule) {
        return true;
    }

    public List<TradeRule> getRules();

    public void clearRules();

    default public void updateRule(ResourceLocation type, CompoundTag updateInfo) {
        TradeRule rule = TradeRule.getRule(type, this.getRules());
        if (rule == null && TradeRule.isCreateMessage(updateInfo)) {
            TradeRule newRule = TradeRule.CreateRule(type);
            if (newRule == null) {
                return;
            }
            this.getRules().add(newRule);
        }
        if (rule != null) {
            if (TradeRule.isRemoveMessage(updateInfo)) {
                this.getRules().remove(rule);
            } else {
                rule.handleUpdateMessage(updateInfo);
            }
        }
    }

    public void markRulesDirty();

    public static <T extends ITradeRuleHandler> void savePersistentRuleData(CompoundTag data, @Nullable ITradeRuleHandler trader, @Nullable List<T> trades) {
        if (trader != null && trader.getRules().size() > 0) {
            TradeRule.writePersistentData(data, trader.getRules(), "TraderRuleData");
        }
        if (trades != null) {
            ListTag tradeData = new ListTag();
            for (int i = 0; i < trades.size(); ++i) {
                CompoundTag ruleData;
                ITradeRuleHandler trade = (ITradeRuleHandler)trades.get(i);
                if (trade.getRules().size() <= 0 || !TradeRule.writePersistentData(ruleData = new CompoundTag(), trade.getRules(), "Data")) continue;
                ruleData.m_128405_("index", i);
                tradeData.add((Object)ruleData);
            }
            if (tradeData.size() > 0) {
                data.m_128365_("TradeRuleData", (Tag)tradeData);
            }
        }
    }

    public static void readPersistentRuleData(CompoundTag data, @Nullable ITradeRuleHandler trader, @Nullable List<? extends ITradeRuleHandler> trades) {
        if (trader != null) {
            TradeRule.readPersistentData(data, trader.getRules(), "TraderRuleData");
        }
        if (trades != null && data.m_128425_("TradeRuleData", 9)) {
            ListTag tradeData = data.m_128437_("TradeRuleData", 10);
            for (int i = 0; i < tradeData.size(); ++i) {
                CompoundTag ruleData = tradeData.m_128728_(i);
                int index = ruleData.m_128451_("index");
                if (index < 0 || index >= trades.size()) continue;
                TradeRule.readPersistentData(ruleData, trades.get(index).getRules(), "Data");
            }
        }
    }

    public static interface ITradeRuleMessageHandler {
        public void receiveTradeRuleMessage(Player var1, int var2, ResourceLocation var3, CompoundTag var4);
    }
}

