/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.buttons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.ActionInstance;
import shadows.menu.buttons.AnchorPoint;
import shadows.menu.buttons.ButtonAction;

public class JsonButton
extends Button {
    protected ResourceLocation texture = f_93617_;
    protected int u;
    protected int v;
    protected int hoverU;
    protected int hoverV;
    protected int texWidth;
    protected int texHeight;
    protected final int xOff;
    protected final int yOff;
    protected boolean usesWidgets = false;
    protected String langKey;
    protected String hoverKey;
    protected final int fontColor;
    protected final int hoverFontColor;
    protected AnchorPoint anchor = AnchorPoint.DEFAULT;
    protected int textXOff;
    protected int textYOff;
    protected boolean dropShadow;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected int scrollCounter = 0;
    protected Component hoverMessage;

    public JsonButton(int xPos, int yPos, int width, int height, int fontColor, int hoverFontColor, String langKey, ActionInstance handler) {
        super(xPos, yPos, width, height, (Component)new TranslatableComponent(langKey), (Button.OnPress)handler, Button.f_93716_);
        handler.setSource(this);
        this.xOff = xPos;
        this.yOff = yPos;
        this.langKey = langKey;
        this.fontColor = fontColor;
        this.hoverFontColor = hoverFontColor;
    }

    public JsonButton texture(ResourceLocation texture, int u, int v, int hoverU, int hoverV, int texWidth, int texHeight) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
        this.texHeight = texHeight;
        this.texWidth = texWidth;
        return this;
    }

    public JsonButton anchor(AnchorPoint anchor) {
        this.anchor = anchor;
        return this;
    }

    public JsonButton usesWidgets(boolean widgets) {
        this.usesWidgets = widgets;
        return this;
    }

    public JsonButton textOffsets(int x, int y) {
        this.textXOff = x;
        this.textYOff = y;
        return this;
    }

    public JsonButton setup(ExtendedMenuScreen screen) {
        this.f_93620_ = this.xOff + this.anchor.getX(screen);
        this.f_93621_ = this.yOff + this.anchor.getY(screen);
        this.m_93666_((Component)new TranslatableComponent(this.langKey));
        this.hoverMessage = new TranslatableComponent(this.hoverKey);
        return this;
    }

    public JsonButton dropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public JsonButton scale(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
        return this;
    }

    public JsonButton hoverText(String hoverKey) {
        this.hoverKey = Strings.isNullOrEmpty((String)hoverKey) ? this.langKey : hoverKey;
        return this;
    }

    public Component m_6035_() {
        if (this.f_93622_) {
            return this.hoverMessage;
        }
        return super.m_6035_();
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            if (this.usesWidgets) {
                this.renderWidgetButton(stack, mouseX, mouseY, partial);
            } else {
                this.renderImageButton(stack, mouseX, mouseY, partial);
            }
        }
    }

    public static void drawCenteredStringNoShadow(PoseStack stack, Font font, String string, int x, int y, int color) {
        font.m_92883_(stack, string, (float)(x - font.m_92895_(string) / 2), (float)y, color);
    }

    public void drawCenteredString0(PoseStack stack, Font font, String string, int x, int y, int color) {
        if (this.dropShadow) {
            Button.m_93208_((PoseStack)stack, (Font)font, (String)string, (int)x, (int)y, (int)color);
        } else {
            JsonButton.drawCenteredStringNoShadow(stack, font, string, x, y, color);
        }
    }

    private void renderWidgetButton(PoseStack stack, int mouseX, int mouseY, float partial) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.m_7202_(this.m_198029_());
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.m_93228_(stack, this.f_93620_, this.f_93621_, 0, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_93228_(stack, this.f_93620_ + this.f_93618_ / 2, this.f_93621_, 200 - this.f_93618_ / 2, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_7906_(stack, mc, mouseX, mouseY);
        this.renderText(stack);
    }

    private void renderImageButton(PoseStack stack, int mouseX, int mouseY, float partial) {
        this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_69465_();
        int x = this.u;
        int y = this.v;
        if (this.m_198029_()) {
            x = this.hoverU;
            y = this.hoverV;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_85836_();
        stack.m_85841_(this.scaleX, this.scaleY, 1.0f);
        JsonButton.m_93133_((PoseStack)stack, (int)Math.round((float)this.f_93620_ / this.scaleX), (int)Math.round((float)this.f_93621_ / this.scaleY), (float)x, (float)y, (int)Math.round((float)this.f_93618_ / this.scaleX), (int)Math.round((float)this.f_93619_ / this.scaleY), (int)this.texWidth, (int)this.texHeight);
        stack.m_85849_();
        RenderSystem.m_69482_();
        this.renderText(stack);
    }

    protected void renderText(PoseStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        int color = this.getFGColor();
        Object buttonText = this.m_6035_().getString();
        int strWidth = mc.f_91062_.m_92895_((String)buttonText);
        if (strWidth <= this.f_93618_ - 6) {
            this.drawCenteredString0(stack, mc.f_91062_, (String)buttonText, this.f_93620_ + this.f_93618_ / 2 + this.textXOff, this.f_93621_ + this.f_93619_ / 2 + this.textYOff, color);
        } else if (!this.f_93622_) {
            this.scrollCounter = 0;
            int ellipsisWidth = mc.f_91062_.m_92895_("...");
            if (strWidth > ellipsisWidth) {
                buttonText = this.trimStringToWidth((FormattedText)this.m_6035_(), this.f_93618_ - 6 - ellipsisWidth).getString().trim() + "...";
            }
            this.drawCenteredString0(stack, mc.f_91062_, (String)buttonText, this.f_93620_ + this.f_93618_ / 2 + this.textXOff, this.f_93621_ + this.f_93619_ / 2 + this.textYOff, color);
        } else {
            int halfLen = mc.f_91062_.m_92895_((String)buttonText + "      ");
            buttonText = (String)buttonText + "      " + (String)buttonText;
            stack.m_85836_();
            double d0 = mc.m_91268_().m_85449_();
            float y = Minecraft.m_91087_().f_91080_.f_96544_ - this.f_93621_ - this.f_93619_;
            RenderSystem.m_69488_((int)((int)((double)this.f_93620_ * d0)), (int)((int)((double)y * d0)), (int)((int)(d0 * (double)this.f_93618_)), (int)((int)(d0 * (double)this.f_93619_)));
            stack.m_85837_((double)(((float)(-this.scrollCounter) - mc.m_91297_()) % (float)halfLen), 0.0, 0.0);
            if (this.dropShadow) {
                mc.f_91062_.m_92750_(stack, (String)buttonText, (float)(this.f_93620_ + this.f_93618_ / 8 + this.textXOff), (float)(this.f_93621_ + this.f_93619_ / 2 + this.textYOff), color);
            } else {
                mc.f_91062_.m_92883_(stack, (String)buttonText, (float)(this.f_93620_ + this.f_93618_ / 8 + this.textXOff), (float)(this.f_93621_ + this.f_93619_ / 2 + this.textYOff), color);
            }
            RenderSystem.m_69471_();
            stack.m_85849_();
        }
    }

    public void tickScrollCounter() {
        ++this.scrollCounter;
    }

    public FormattedText trimStringToWidth(FormattedText str, int width) {
        return (FormattedText)Minecraft.m_91087_().f_91062_.m_92865_().m_92414_(str, width, Style.f_131099_).get(0);
    }

    public int getFGColor() {
        return !this.f_93622_ ? this.fontColor : this.hoverFontColor;
    }

    public static JsonButton deserialize(JsonObject obj) {
        JsonElement x = obj.get("x");
        JsonElement y = obj.get("y");
        JsonElement width = obj.get("width");
        JsonElement height = obj.get("height");
        JsonElement tex = obj.get("texture");
        JsonElement u = obj.get("u");
        JsonElement v = obj.get("v");
        JsonElement hoverU = obj.get("hoverU");
        JsonElement hoverV = obj.get("hoverV");
        JsonElement texWidth = obj.get("texWidth");
        JsonElement texHeight = obj.get("texHeight");
        JsonElement widgets = obj.get("widgets");
        JsonElement langKey = obj.get("langKey");
        JsonElement hoverLangKey = obj.get("hoverLangKey");
        JsonElement action = obj.get("action");
        JsonElement fontColor = obj.get("fontColor");
        JsonElement hoverFontColor = obj.get("hoverFontColor");
        JsonElement anchor = obj.get("anchor");
        JsonElement textX = obj.get("textXOffset");
        JsonElement textY = obj.get("textYOffset");
        JsonElement dropShadow = obj.get("dropShadow");
        JsonElement active = obj.get("active");
        JsonElement scaleX = obj.get("scaleX");
        JsonElement scaleY = obj.get("scaleY");
        ResourceLocation _tex = tex == null ? f_93617_ : new ResourceLocation(tex.getAsString());
        int _u = JsonButton.get(u, 0);
        int _v = JsonButton.get(v, 0);
        int _hoverU = JsonButton.get(hoverU, 0);
        int _hoverV = JsonButton.get(hoverV, 0);
        int _x = JsonButton.get(x, 0);
        int _y = JsonButton.get(y, 0);
        int _width = JsonButton.get(width, 0);
        int _height = JsonButton.get(height, 0);
        int _texWidth = JsonButton.get(texWidth, 256);
        int _texHeight = JsonButton.get(texHeight, 256);
        boolean _widgets = widgets == null ? _tex.toString().contains("widgets") : widgets.getAsBoolean();
        int _fontColor = JsonButton.get(fontColor, 0xFFFFFF);
        int _hoverFontColor = JsonButton.get(hoverFontColor, 0xFFFFFF);
        String displayKey = langKey == null ? "" : langKey.getAsString();
        String hoverKey = hoverLangKey == null ? "" : hoverLangKey.getAsString();
        ButtonAction act = ButtonAction.valueOf(action.getAsString().toUpperCase(Locale.ROOT));
        AnchorPoint _anchor = anchor == null ? AnchorPoint.DEFAULT : AnchorPoint.valueOf(anchor.getAsString());
        Object data = act.readData(obj);
        int _textX = JsonButton.get(textX, 0);
        int _textY = JsonButton.get(textY, -4);
        float _scaleX = JsonButton.get(scaleX, 1.0f);
        float _scaleY = JsonButton.get(scaleY, 1.0f);
        boolean _dropShadow = dropShadow == null ? true : dropShadow.getAsBoolean();
        JsonButton button = new JsonButton(_x, _y, _width, _height, _fontColor, _hoverFontColor, displayKey, new ActionInstance(act, data));
        button.texture(_tex, _u, _v, _hoverU, _hoverV, _texWidth, _texHeight).usesWidgets(_widgets).anchor(_anchor);
        button.textOffsets(_textX, _textY).dropShadow(_dropShadow).scale(_scaleX, _scaleY).hoverText(hoverKey);
        button.f_93623_ = active == null ? true : active.getAsBoolean();
        return button;
    }

    private static int get(JsonElement e, int def) {
        return e == null ? def : e.getAsInt();
    }

    private static float get(JsonElement e, float def) {
        return e == null ? def : e.getAsFloat();
    }
}

