/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.impl;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BeddingMaterial
extends IBeddingMaterial {
    private final Supplier<Block> block;
    protected ResourceLocation texture;
    @Nullable
    private String translationKey;

    public BeddingMaterial(Supplier<Block> blockIn) {
        this.block = blockIn;
    }

    public BeddingMaterial(Supplier<Block> blockIn, ResourceLocation texture) {
        this.block = blockIn;
        this.texture = texture;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            ResourceLocation loc = this.block.get().getRegistryName();
            this.texture = new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_());
        }
        return this.texture;
    }

    @Override
    public Component getTooltip() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"dogbed.bedding", (ResourceLocation)DoggyTalentsAPI.BEDDING_MATERIAL.get().getKey((IForgeRegistryEntry)this));
        }
        return new TranslatableComponent(this.translationKey);
    }

    @Override
    public Ingredient getIngredient() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.block.get()});
    }
}

