/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public class BreedGoal
extends Goal {
    private static final TargetingConditions breedPredicate = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Animal animal;
    private final Class<? extends Animal> mateClass;
    private final Level world;
    private final double moveSpeed;
    protected Animal targetMate;
    private int spawnBabyDelay;

    public BreedGoal(Animal animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public BreedGoal(Animal animal, double moveSpeed, Class<? extends Animal> mateClass) {
        this.animal = animal;
        this.world = animal.f_19853_;
        this.mateClass = mateClass;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.animal.m_27593_()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean m_8045_() {
        return this.targetMate.m_6084_() && this.targetMate.m_27593_() && this.spawnBabyDelay < 60;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.animal.m_8132_());
        this.animal.m_21573_().m_5624_((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.animal.m_20280_((Entity)this.targetMate) < 9.0) {
            this.animal.m_27563_((ServerLevel)this.world, this.targetMate);
        }
    }

    @Nullable
    private Animal getNearbyMate() {
        List entities = this.world.m_6443_(this.mateClass, this.animal.m_142469_().m_82400_(8.0), this::filterEntities);
        return (Animal)EntityUtil.getClosestTo((Entity)this.animal, entities);
    }

    private boolean filterEntities(Animal entity) {
        return breedPredicate.m_26885_((LivingEntity)this.animal, (LivingEntity)entity) && this.animal.m_7848_(entity);
    }
}

