/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.stats;

import com.google.common.collect.Maps;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class StatsTracker {
    private Map<EntityType<?>, Integer> ENTITY_KILLS = Maps.newHashMap();
    private float damageDealt = 0.0f;
    private int distanceOnWater = 0;
    private int distanceInWater = 0;
    private int distanceSprinting = 0;
    private int distanceSneaking = 0;
    private int distanceWalking = 0;
    private int distanceRidden = 0;
    private final Cache<Integer> killCount = Cache.make(this::getTotalKillCountInternal);

    public void writeAdditional(CompoundTag compound) {
        ListTag killList = new ListTag();
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            CompoundTag stats = new CompoundTag();
            NBTUtil.putRegistryValue(stats, "type", entry.getKey());
            stats.m_128405_("count", entry.getValue().intValue());
            killList.add((Object)stats);
        }
        compound.m_128365_("entityKills", (Tag)killList);
        compound.m_128347_("damageDealt", (double)this.damageDealt);
        compound.m_128405_("distanceOnWater", this.distanceOnWater);
        compound.m_128405_("distanceInWater", this.distanceInWater);
        compound.m_128405_("distanceSprinting", this.distanceSprinting);
        compound.m_128405_("distanceSneaking", this.distanceSneaking);
        compound.m_128405_("distanceWalking", this.distanceWalking);
        compound.m_128405_("distanceRidden", this.distanceRidden);
    }

    public void readAdditional(CompoundTag compound) {
        ListTag killList = compound.m_128437_("entityKills", 10);
        for (int i = 0; i < killList.size(); ++i) {
            CompoundTag stats = killList.m_128728_(i);
            EntityType type = (EntityType)NBTUtil.getRegistryValue(stats, "type", ForgeRegistries.ENTITIES);
            this.ENTITY_KILLS.put(type, stats.m_128451_("count"));
        }
        this.damageDealt = compound.m_128457_("damageDealt");
        this.distanceOnWater = compound.m_128451_("distanceOnWater");
        this.distanceInWater = compound.m_128451_("distanceInWater");
        this.distanceSprinting = compound.m_128451_("distanceSprinting");
        this.distanceSneaking = compound.m_128451_("distanceSneaking");
        this.distanceWalking = compound.m_128451_("distanceWalking");
        this.distanceRidden = compound.m_128451_("distanceRidden");
    }

    public int getKillCountFor(EntityType<?> type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    public int getKillCountFor(Predicate<MobCategory> classification) {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            if (!classification.test(entry.getKey().m_20674_())) continue;
            total += entry.getValue().intValue();
        }
        return total;
    }

    private int getTotalKillCountInternal() {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public int getTotalKillCount() {
        return this.killCount.get();
    }

    public void incrementKillCount(Entity entity) {
        this.incrementKillCount(entity.m_6095_());
    }

    private void incrementKillCount(EntityType<?> type) {
        this.ENTITY_KILLS.compute(type, (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void increaseDamageDealt(float damage) {
        this.damageDealt += damage;
    }

    public void increaseDistanceOnWater(int distance) {
        this.distanceOnWater += distance;
    }

    public void increaseDistanceInWater(int distance) {
        this.distanceInWater += distance;
    }

    public void increaseDistanceSprint(int distance) {
        this.distanceSprinting += distance;
    }

    public void increaseDistanceSneaking(int distance) {
        this.distanceSneaking += distance;
    }

    public void increaseDistanceWalk(int distance) {
        this.distanceWalking += distance;
    }

    public void increaseDistanceRidden(int distance) {
        this.distanceRidden += distance;
    }
}

