/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RadarItem
extends Item {
    public RadarItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            if (playerIn.m_6144_()) {
                DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
                for (UUID uuid : locationManager.getAllUUID()) {
                    playerIn.m_6352_((Component)new TextComponent(locationManager.getData(uuid).toString()), Util.f_137441_);
                }
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
            }
            ResourceKey dimCurr = playerIn.f_19853_.m_46472_();
            playerIn.m_6352_((Component)new TextComponent(""), Util.f_137441_);
            DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
            List ownDogs = locationManager.getDogs((LivingEntity)playerIn, (ResourceKey<Level>)dimCurr).collect(Collectors.toList());
            if (ownDogs.isEmpty()) {
                playerIn.m_6352_((Component)new TranslatableComponent("dogradar.errornull", new Object[]{dimCurr.m_135782_()}), Util.f_137441_);
            } else {
                boolean flag = false;
                for (DogLocationData loc : ownDogs) {
                    if (!loc.shouldDisplay(worldIn, playerIn, handIn)) continue;
                    flag = true;
                    String translateStr = RadarItem.getDirectionTranslationKey(loc, (Entity)playerIn);
                    int distance = Mth.m_14165_((double)(loc.getPos() != null ? loc.getPos().m_82554_(playerIn.m_20182_()) : -1.0));
                    playerIn.m_6352_((Component)new TranslatableComponent(translateStr, new Object[]{loc.getName(worldIn), distance}), Util.f_137441_);
                }
                if (!flag) {
                    playerIn.m_6352_((Component)new TranslatableComponent("dogradar.errornoradio"), Util.f_137441_);
                }
            }
            ArrayList<ResourceKey> otherDogs = new ArrayList<ResourceKey>();
            ArrayList noDogs = new ArrayList();
            for (ResourceKey worldkey : worldIn.m_142572_().m_129784_()) {
                if (worldkey.equals((Object)worldIn.m_46472_())) continue;
                ownDogs = locationManager.getDogs((LivingEntity)playerIn, (ResourceKey<Level>)worldkey).collect(Collectors.toList());
                (ownDogs.size() > 0 ? otherDogs : noDogs).add(worldkey);
            }
            if (otherDogs.size() > 0) {
                playerIn.m_6352_((Component)new TranslatableComponent("dogradar.notindim", new Object[]{otherDogs.stream().map(ResourceKey::m_135782_).map(Objects::toString).collect(Collectors.joining(", "))}), Util.f_137441_);
            }
            if (noDogs.size() > 0 && stack.m_41720_() == DoggyItems.CREATIVE_RADAR.get()) {
                playerIn.m_6352_((Component)new TranslatableComponent("dogradar.errornull", new Object[]{noDogs.stream().map(ResourceKey::m_135782_).map(Objects::toString).collect(Collectors.joining(", "))}), Util.f_137441_);
            }
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public static String getDirectionTranslationKey(DogLocationData loc, Entity entity) {
        if (loc.getPos() == null) {
            return "dogradar.unknown";
        }
        Vec3 diff = loc.getPos().m_82549_(entity.m_20182_().m_82548_());
        double angle = Mth.m_14136_((double)diff.m_7096_(), (double)diff.m_7094_());
        if (angle < -2.748893571891069) {
            return "dogradar.north";
        }
        if (angle < -1.9634954084936207) {
            return "dogradar.north.west";
        }
        if (angle < -1.1780972450961724) {
            return "dogradar.west";
        }
        if (angle < -0.39269908169872414) {
            return "dogradar.south.west";
        }
        if (angle < 0.39269908169872414) {
            return "dogradar.south";
        }
        if (angle < 1.178097245096172) {
            return "dogradar.south.east";
        }
        if (angle < 1.9634954084936211) {
            return "dogradar.east";
        }
        if (angle < 2.7488935718910685) {
            return "dogradar.north.east";
        }
        return "dogradar.north";
    }
}

