/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogFoodPredicate;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HappyEaterTalent
extends TalentInstance
implements IDogFoodHandler {
    public static final IDogFoodPredicate INNER_DYN_PRED = stackIn -> {
        Item item = stackIn.m_41720_();
        return item == Items.f_42583_ || item.m_41472_() && stackIn.m_204117_(ItemTags.f_13156_);
    };

    public HappyEaterTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResultHolder<Float> setDogHunger(AbstractDogEntity dogIn, float hunger, float diff) {
        return InteractionResultHolder.m_19090_((Object)Float.valueOf(hunger += diff / 10.0f * (float)this.level()));
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        return INNER_DYN_PRED.isFood(stackIn);
    }

    @Override
    public boolean canConsume(AbstractDogEntity dogIn, ItemStack stackIn, Entity entityIn) {
        if (this.level() >= 3) {
            Item item = stackIn.m_41720_();
            if (item == Items.f_42583_) {
                return true;
            }
            if (this.level() >= 5 && item.m_41472_() && stackIn.m_204117_(ItemTags.f_13156_)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public InteractionResult consume(AbstractDogEntity dogIn, ItemStack stackIn, Entity entityIn) {
        if (this.level() >= 3) {
            Item item = stackIn.m_41720_();
            if (item == Items.f_42583_) {
                dogIn.addHunger(30.0f);
                dogIn.consumeItemFromStack(entityIn, stackIn);
                return InteractionResult.SUCCESS;
            }
            if (this.level() >= 5 && item.m_41472_() && stackIn.m_204117_(ItemTags.f_13156_)) {
                dogIn.addHunger(item.m_41473_().m_38744_() * 5);
                dogIn.consumeItemFromStack(entityIn, stackIn);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

