/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class ShepherdDogTalent
extends TalentInstance {
    private static DataKey<EntityAIShepherdDog> SHEPHERD_AI = DataKey.make();

    public ShepherdDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        if (!dogIn.hasData(SHEPHERD_AI)) {
            EntityAIShepherdDog shepherdAI = new EntityAIShepherdDog(dogIn, 1.0, 8.0f, entity -> !(entity instanceof TamableAnimal));
            dogIn.f_21345_.m_25352_(7, (Goal)shepherdAI);
            dogIn.setData(SHEPHERD_AI, (Object)shepherdAI);
        }
    }

    public static int getMaxFollowers(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public static class EntityAIShepherdDog
    extends Goal {
        protected final AbstractDogEntity dog;
        private final Level world;
        private final double followSpeed;
        private final float maxDist;
        private final PathNavigation dogPathfinder;
        private final Predicate<ItemStack> holdingPred;
        private final Predicate<Animal> predicate;
        private final Comparator<Entity> sorter;
        private int timeToRecalcPath;
        private LivingEntity owner;
        protected List<Animal> targets;
        private float oldWaterCost;
        private int MAX_FOLLOW = 5;

        public EntityAIShepherdDog(AbstractDogEntity dogIn, double speedIn, float range, @Nullable Predicate<Animal> targetSelector) {
            this.dog = dogIn;
            this.world = dogIn.f_19853_;
            this.dogPathfinder = dogIn.m_21573_();
            this.followSpeed = speedIn;
            this.maxDist = range;
            this.predicate = entity -> {
                double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
                if (entity.m_20145_()) {
                    return false;
                }
                if (targetSelector != null && !targetSelector.test((Animal)entity)) {
                    return false;
                }
                return (double)entity.m_20270_((Entity)this.dog) > d0 ? false : entity.m_142582_((Entity)this.dog);
            };
            this.holdingPred = stack -> stack.m_41720_() == DoggyItems.WHISTLE.get();
            this.sorter = new EntityUtil.Sorter((Entity)dogIn);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.dog.getMode() != EnumMode.DOCILE) {
                return false;
            }
            if (this.dog.getDogLevel((Supplier)DoggyTalents.SHEPHERD_DOG) <= 0) {
                return false;
            }
            LivingEntity owner = this.dog.m_142480_();
            if (owner == null) {
                return false;
            }
            if (owner instanceof Player && ((Player)owner).m_5833_()) {
                return false;
            }
            if (!EntityUtil.isHolding((Entity)owner, (Item)DoggyItems.WHISTLE.get(), nbt -> nbt.m_128441_("mode") && nbt.m_128451_("mode") == 4)) {
                return false;
            }
            List list = this.world.m_6443_(Animal.class, this.dog.m_142469_().m_82377_(12.0, 4.0, 12.0), this.predicate);
            Collections.sort(list, this.sorter);
            if (list.isEmpty()) {
                return false;
            }
            this.MAX_FOLLOW = ShepherdDogTalent.getMaxFollowers(this.dog.getDogLevel((Supplier)DoggyTalents.SHEPHERD_DOG));
            this.targets = list.subList(0, Math.min(this.MAX_FOLLOW, list.size()));
            this.owner = owner;
            return true;
        }

        public boolean m_8045_() {
            if (this.dog.getMode() != EnumMode.DOCILE) {
                return false;
            }
            if (this.dog.getDogLevel((Supplier)DoggyTalents.SHEPHERD_DOG) <= 0) {
                return false;
            }
            if (!EntityUtil.isHolding((Entity)this.owner, (Item)DoggyItems.WHISTLE.get(), nbt -> nbt.m_128441_("mode") && nbt.m_128451_("mode") == 4)) {
                return false;
            }
            return !this.targets.isEmpty();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
            this.dog.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8037_() {
            if (!this.dog.m_21825_() && --this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (this.targets.size() < this.MAX_FOLLOW) {
                    List list = this.world.m_6443_(Animal.class, this.dog.m_142469_().m_82377_(16.0, 4.0, 16.0), this.predicate);
                    list.removeAll(this.targets);
                    Collections.sort(list, this.sorter);
                    this.targets.addAll(list.subList(0, Math.min(this.MAX_FOLLOW - this.targets.size(), list.size())));
                }
                Collections.sort(this.targets, this.sorter);
                boolean teleport = this.owner.m_20270_((Entity)this.targets.get(0)) > 16.0f;
                for (Animal animal : this.targets) {
                    double distanceAway = animal.m_20270_((Entity)this.owner);
                    animal.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)animal.m_8132_());
                    if (teleport) {
                        if (animal.m_21523_() || animal.m_20159_()) continue;
                        EntityUtil.tryToTeleportNearEntity((LivingEntity)animal, animal.m_21573_(), this.owner, 4);
                        continue;
                    }
                    if (distanceAway >= 5.0) {
                        if (animal.m_21573_().m_5624_((Entity)this.owner, 1.2) || animal.m_21523_() || animal.m_20159_() || !(distanceAway >= 20.0)) continue;
                        EntityUtil.tryToTeleportNearEntity((LivingEntity)animal, animal.m_21573_(), this.owner, 4);
                        continue;
                    }
                    animal.m_21573_().m_26573_();
                }
                Vec3 vec = Vec3.f_82478_;
                for (Animal target : this.targets) {
                    vec = vec.m_82549_(target.m_20182_());
                }
                vec = vec.m_82490_(1.0 / (double)this.targets.size());
                double d = vec.f_82479_ - this.owner.m_20185_();
                double dPosZ = vec.f_82481_ - this.owner.m_20189_();
                double size = Math.sqrt(d * d + dPosZ * dPosZ);
                double j3 = vec.f_82479_ + d / size * (double)(2 + this.targets.size() / 16);
                double k3 = vec.f_82481_ + dPosZ / size * (double)(2 + this.targets.size() / 16);
                if (teleport) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, new BlockPos(j3, this.dog.m_20186_(), k3), 1);
                }
                this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
                if (!this.dogPathfinder.m_26519_(j3, this.owner.m_142469_().f_82289_, k3, this.followSpeed) && this.dog.m_20275_(j3, this.owner.m_142469_().f_82289_, k3) > 144.0 && !this.dog.m_21523_() && !this.dog.m_20159_()) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, new BlockPos(j3, this.dog.m_20186_(), k3), 4);
                }
                if (this.dog.m_20270_((Entity)this.owner) > 40.0f) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, this.owner, 2);
                }
                if (this.dog.m_21187_().nextFloat() < 0.15f) {
                    this.dog.m_5496_(SoundEvents.f_12617_, this.dog.m_6121_() + 1.0f, (this.dog.m_21187_().nextFloat() - this.dog.m_21187_().nextFloat()) * 0.1f + 0.9f);
                }
                ArrayList<Animal> toRemove = new ArrayList<Animal>();
                for (Animal target : this.targets) {
                    if (target.m_6084_() && !((double)target.m_20270_((Entity)this.dog) > 25.0)) continue;
                    toRemove.add(target);
                }
                this.targets.removeAll(toRemove);
            }
        }

        public void m_8041_() {
            this.owner = null;
            for (Animal target : this.targets) {
                target.m_21573_().m_26573_();
            }
            this.dogPathfinder.m_26573_();
            this.dog.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }
    }
}

