/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.arcade.games;

import com.mrh0.buildersaddition.arcade.ArcadeGame;
import com.mrh0.buildersaddition.arcade.ArcadeScreen;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;

public class ArcadeSnake
extends ArcadeGame {
    int px = 0;
    int py = 0;
    int lpx = 0;
    int lpy = 0;
    int dir = -1;
    int ldir = -1;
    int pw;
    int ph;
    long deadTimer = Long.MAX_VALUE;
    boolean isDead = false;
    int snakeColor = 10;
    int score;
    boolean initScreen = true;
    Tail last = null;
    Tail first = null;
    int tailExt = 0;

    public ArcadeSnake(ArcadeScreen s, ArcadeTileEntity te) {
        super(s, te);
        this.pw = s.width - 10;
        this.ph = s.height;
    }

    @Override
    public void start() {
        super.start();
        this.s.clear();
        this.s.testScreen();
        this.s.setColors(0, 15);
        this.s.clear(0, 1, this.s.width, this.s.height - 2);
        this.s.print(1, 1, "Arcade Snake v1.0");
        String msg = " Press any key to continue. ";
        this.s.print(this.s.width / 2 - msg.length() / 2, this.s.height / 2, msg);
        this.initScreen = false;
        this.begin();
        this.dir = -1;
    }

    private void begin() {
        this.s.setColors(0, 15);
        this.s.clear();
        this.px = this.pw / 2;
        this.py = this.ph / 2;
        this.lpx = this.px;
        this.lpy = this.py;
        this.dir = -1;
        this.ldir = -1;
        this.score = 0;
        this.isDead = false;
        this.deadTimer = Long.MAX_VALUE;
        this.last = null;
        this.first = null;
        this.tailExt = 0;
        this.s.setColors(8, 10);
        this.s.clear(this.pw, 0, this.s.width - this.pw, this.s.height);
        this.s.print(this.pw + 1, 1, "Score:");
        this.s.print(this.pw + 1, 2, "" + this.score);
        this.s.print(this.pw + 1, this.s.height - 5, "Arrows");
        this.s.print(this.pw + 1, this.s.height - 4, "or WASD");
        this.spawnFood();
        this.spawnFood();
    }

    public int randomRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private void spawnFood() {
        int x = 0;
        int y = 0;
        while (this.s.getBackground(x = this.randomRange(0, this.pw), y = this.randomRange(0, this.ph)) != 0 && this.s.getChar(x, y) != 'o') {
        }
        this.s.setColors(0, 14);
        this.s.print(x, y, "o");
        this.s.setColors(8, 10);
        this.s.print(this.pw + 1, this.s.height - 2, this.repeat(">", 7 - this.tickRate(this.score)));
    }

    private int tickRate(int t) {
        if (t > 20) {
            return 2;
        }
        if (t > 10) {
            return 3;
        }
        if (t > 7) {
            return 4;
        }
        if (t > 3) {
            return 5;
        }
        return 6;
    }

    private String repeat(String t, int n) {
        Object r = "";
        for (int i = 0; i < n; ++i) {
            r = (String)r + t;
        }
        return r;
    }

    private void updateMovement(long time) {
        this.lpx = this.px++;
        this.lpy = this.py--;
        if (this.dir >= 0) {
            switch (this.dir) {
                case 0: {
                    if (this.py >= 0) break;
                    this.py = this.ph - 1;
                    break;
                }
                case 1: {
                    if (this.px <= this.pw - 1) break;
                    this.px = 0;
                    break;
                }
                case 2: {
                    ++this.py;
                    if (this.py <= this.ph - 1) break;
                    this.py = 0;
                    break;
                }
                case 3: {
                    --this.px;
                    if (this.px >= 0) break;
                    this.px = this.pw - 1;
                }
            }
            if (this.s.getBackground(this.px, this.py) == this.snakeColor) {
                this.deadTimer = time + 60L;
                this.isDead = true;
                this.s.setColors(4, 15);
                this.s.print(this.px, this.py, "x");
                this.playSound(0);
                return;
            }
            if (this.s.getChar(this.px, this.py) == 'o') {
                ++this.score;
                this.s.setColors(8, 10);
                this.s.print(this.pw + 1, 1, "Score:");
                this.s.print(this.pw + 1, 2, "" + this.score);
                this.spawnFood();
                this.tailExt = 3;
                this.playSound(30);
            }
            if (this.last != null && this.tailExt <= 0) {
                this.s.setColors(0, 15);
                this.s.print(this.last.x, this.last.y, " ");
                this.last = this.last.next;
            }
            this.s.setColors(this.snakeColor, 15);
            this.s.print(this.lpx, this.lpy, this.getToken(this.dir, this.ldir));
            this.ldir = this.dir;
            Tail t = new Tail(this.lpx, this.lpy, null);
            if (this.first != null) {
                this.first.next = t;
            }
            this.first = t;
            if (this.last == null) {
                this.last = t;
            }
            --this.tailExt;
            if (this.tailExt < 0) {
                this.tailExt = 0;
            }
        }
        this.s.setColors(this.snakeColor, 15);
        this.s.print(this.px, this.py, "@");
    }

    private String getToken(int d, int ld) {
        if (d == ld) {
            return this.dir == 0 || this.dir == 2 ? "-" : "|";
        }
        if (d == 0 && ld == 1 || d == 1 && ld == 0) {
            return "\\";
        }
        if (d == 0 && ld == 3 || d == 3 && ld == 0) {
            return "/";
        }
        if (d == 2 && ld == 1 || d == 1 && ld == 2) {
            return "/";
        }
        if (d == 2 && ld == 3 || d == 3 && ld == 2) {
            return "\\";
        }
        return "-";
    }

    @Override
    public void frame(long time) {
        super.frame(time);
        if (time > this.deadTimer) {
            this.begin();
        }
        if (time % (long)this.tickRate(this.score) == 0L && !this.isDead) {
            this.updateMovement(time);
        }
    }

    @Override
    public void onKeyPressed(int key) {
        super.onKeyPressed(key);
        if (this.initScreen && ArcadeSnake.isAny(key)) {
            this.initScreen = false;
            this.begin();
        }
        if (ArcadeSnake.isUp(key) && this.ldir != 2) {
            this.dir = 0;
        } else if (ArcadeSnake.isRight(key) && this.ldir != 3) {
            this.dir = 1;
        } else if (ArcadeSnake.isDown(key) && this.ldir != 0) {
            this.dir = 2;
        } else if (ArcadeSnake.isLeft(key) && this.ldir != 1) {
            this.dir = 3;
        } else if (ArcadeSnake.isReset(key)) {
            this.s.setColors(4, 0);
            String msg = " Restarting. ";
            this.s.print(this.pw / 2 - msg.length() / 2, this.s.height / 2, msg);
        }
    }

    @Override
    public void onKeyReleased(int key) {
        super.onKeyReleased(key);
        if (ArcadeSnake.isReset(key)) {
            this.begin();
        }
    }

    private class Tail {
        public int x;
        public int y;
        public Tail next;

        public Tail(int x, int y, Tail next) {
            this.x = x;
            this.y = y;
            this.next = next;
        }
    }
}

