/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.tileentity.BedsideTileEntity;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import com.mrh0.buildersaddition.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BedsideTable
extends BaseDerivativeBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NW = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0);
    protected static final VoxelShape SHAPE_NE = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0);
    protected static final VoxelShape SHAPE_SW = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SE = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_BOX_X = Block.m_49796_((double)1.0, (double)8.0, (double)3.0, (double)15.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_BOX_Z = Block.m_49796_((double)3.0, (double)8.0, (double)1.0, (double)13.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_X = Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_NW, SHAPE_NE, SHAPE_SW, SHAPE_SE, SHAPE_BOX_X});
    protected static final VoxelShape SHAPE_Z = Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_NW, SHAPE_NE, SHAPE_SW, SHAPE_SE, SHAPE_BOX_Z});

    public BedsideTable(String name, Block source) {
        super("bedside_table_" + name, source);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.m_43725_().m_6425_(c.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(world, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(world, pos, state, fluidIn);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    private VoxelShape getShapeForDirection(Direction d) {
        switch (d) {
            case NORTH: {
                return SHAPE_Z;
            }
            case SOUTH: {
                return SHAPE_Z;
            }
            case EAST: {
                return SHAPE_X;
            }
            case WEST: {
                return SHAPE_X;
            }
        }
        return SHAPE_Z;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!Util.accessCheck(world, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_())) {
            return InteractionResult.CONSUME;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof BedsideTileEntity) {
            player.m_5893_((MenuProvider)((BedsideTileEntity)tileentity));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof Container) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileentity));
                world.m_46672_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = world.m_7702_(pos)) instanceof BedsideTileEntity) {
            ((BedsideTileEntity)tileentity).m_58638_(stack.m_41611_());
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity instanceof MenuProvider ? (MenuProvider)tileentity : null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return IComparetorOverride.getComparetorOverride(world, pos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BedsideTileEntity(pos, state);
    }
}

