/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.config.Config;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Candle
extends BaseBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", p -> p != Direction.UP);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)6.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)3.0, (double)6.0, (double)4.0, (double)13.0, (double)10.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)12.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    private ParticleOptions parts;

    public Candle(String name, ParticleOptions parts) {
        super(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.parts = parts;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        if (c.m_43719_() == Direction.DOWN || c.m_43719_() == Direction.UP) {
            if (c.m_43723_().m_7500_()) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.DOWN);
            }
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.DOWN);
        }
        if (c.m_43723_().m_7500_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)c.m_43719_().m_122427_());
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)c.m_43719_().m_122427_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.m_21120_(hand);
        boolean lit = (Boolean)state.m_61143_((Property)LIT);
        if (player.m_7500_() || !((Boolean)Config.REQUIRE_FLINT_AND_STEEL.get()).booleanValue()) {
            if (!lit) {
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (!world.m_5776_()) {
                    world.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                }
            } else {
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12374_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (!world.m_5776_()) {
                    world.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                }
            }
        } else if (item.m_41619_()) {
            if (lit) {
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12374_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (!world.m_5776_()) {
                    world.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                }
            }
        } else if (item.m_41720_() == Items.f_42409_ && !lit) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            if (!world.m_5776_()) {
                world.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                item.m_41622_(1, (LivingEntity)player, e -> {});
            }
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, FACING});
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        double x = 0.5;
        double y = 0.8125;
        double z = 0.5;
        double o = 0.1875;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case EAST: {
                z = 1.0 - o;
                break;
            }
            case NORTH: {
                x = 1.0 - o;
                break;
            }
            case SOUTH: {
                x = o;
                break;
            }
            case WEST: {
                z = o;
                break;
            }
            case DOWN: {
                y = 0.6875;
                break;
            }
        }
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double d0 = (double)pos.m_123341_() + x;
        double d1 = (double)pos.m_123342_() + y;
        double d2 = (double)pos.m_123343_() + z;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        world.m_7106_(this.parts, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

