/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.event;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.data.block.BABlockTagsProvider;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.event.BlockRegistry;
import com.mrh0.buildersaddition.event.ContainerRegistry;
import com.mrh0.buildersaddition.event.ItemRegistry;
import com.mrh0.buildersaddition.event.TileEntityRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildersaddition", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandler {
    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> evt) {
        IForgeRegistry reg = evt.getRegistry();
        Index.blocks();
        BlockRegistry.instance.initAll(reg);
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> evt) {
        IForgeRegistry reg = evt.getRegistry();
        Index.items();
        ItemRegistry.instance.initAll(reg);
    }

    @SubscribeEvent
    public static void registerTileEntity(RegistryEvent.Register<BlockEntityType<?>> evt) {
        IForgeRegistry reg = evt.getRegistry();
        Index.tileentities();
        TileEntityRegistry.instance.initAll(reg);
    }

    @SubscribeEvent
    public static void registerContainer(RegistryEvent.Register<MenuType<?>> evt) {
        IForgeRegistry reg = evt.getRegistry();
        Index.containers();
        ContainerRegistry.instance.initAll(reg);
    }

    @SubscribeEvent
    public static void registerEntityType(RegistryEvent.Register<EntityType<?>> evt) {
        Index.SEAT_ENTITY_TYPE = EntityType.Builder.m_20704_(SeatEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((packet, world) -> new SeatEntity(Index.SEAT_ENTITY_TYPE, (Level)world)).m_20712_("buildersaddition:seat");
        Index.SEAT_ENTITY_TYPE.setRegistryName(new ResourceLocation("buildersaddition", "seat"));
        evt.getRegistry().register(Index.SEAT_ENTITY_TYPE);
    }

    @SubscribeEvent
    public static void registerPaintings(RegistryEvent.Register<Motive> evt) {
        IForgeRegistry reg = evt.getRegistry();
        Index.paintings();
        reg.register((IForgeRegistryEntry)Index.SUMMER_FIELD_PAINTING);
        reg.register((IForgeRegistryEntry)Index.SHARD_PAINTING);
        reg.register((IForgeRegistryEntry)Index.SKARGARD_PAINTING);
        reg.register((IForgeRegistryEntry)Index.HORIZONS_PAINTING);
        reg.register((IForgeRegistryEntry)Index.PORTRAIT_PAINTING);
        reg.register((IForgeRegistryEntry)Index.HEROBRINE_PAINTING);
        reg.register((IForgeRegistryEntry)Index.ENDERMAN_PAINTING);
        reg.register((IForgeRegistryEntry)Index.WINTER_PAINTING);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper exHelper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new BABlockTagsProvider(gen, "buildersaddition", exHelper));
        }
    }
}

