/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.load.registration;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.common.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class AdvancedRegistration
implements IAdvancedRegistration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IRecipeManagerPlugin> recipeManagerPlugins = new ArrayList<IRecipeManagerPlugin>();
    private final IJeiHelpers jeiHelpers;

    public AdvancedRegistration(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public void addRecipeManagerPlugin(IRecipeManagerPlugin recipeManagerPlugin) {
        ErrorUtil.checkNotNull(recipeManagerPlugin, "recipeManagerPlugin");
        LOGGER.info("Added recipe manager plugin: {}", recipeManagerPlugin.getClass());
        this.recipeManagerPlugins.add(recipeManagerPlugin);
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public @Unmodifiable List<IRecipeManagerPlugin> getRecipeManagerPlugins() {
        return List.copyOf(this.recipeManagerPlugins);
    }
}

