/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.IBounds;
import java.util.Objects;

public class FloatBounds
implements IBounds<Float> {
    public static final FloatBounds ZERO = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.0f));
    public static final FloatBounds FLOAT = new FloatBounds(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    public static final FloatBounds FLOAT_POSITIVE = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE));
    private final Float min;
    private final Float max;

    public FloatBounds(Float bound1, Float bound2) {
        this.min = Float.valueOf(Math.min(bound1.floatValue(), bound2.floatValue()));
        this.max = Float.valueOf(Math.max(bound1.floatValue(), bound2.floatValue()));
    }

    public static FloatBounds between(Float bound1, Float bound2) {
        return new FloatBounds(bound1, bound2);
    }

    public static FloatBounds of(Float bound) {
        return FloatBounds.between(bound, bound);
    }

    public static FloatBounds of(IBounds<? extends Number> bounds) {
        return FloatBounds.between(Float.valueOf(bounds.getMin().floatValue()), Float.valueOf(bounds.getMax().floatValue()));
    }

    @Override
    public final Float getMin() {
        return this.min;
    }

    @Override
    public final Float getMax() {
        return this.max;
    }

    @Override
    public boolean encloses(Float value) {
        return value.floatValue() >= this.getMin().floatValue() && value.floatValue() <= this.getMax().floatValue();
    }

    @Override
    public Float enclose(Float value) {
        return Float.valueOf(CommonMath.Range.enclose(value.floatValue(), this.getMin().floatValue(), this.getMax().floatValue()));
    }

    @Override
    public Float randomBetween() {
        return Float.valueOf(CommonMath.Random.between(this.getMin().floatValue(), this.getMax().floatValue()));
    }

    @Override
    public Float interpolateUp(float factor) {
        return Float.valueOf(CommonMath.Interpolation.strictUp(factor, this));
    }

    @Override
    public Float interpolateDown(float factor) {
        return Float.valueOf(CommonMath.Interpolation.strictDown(factor, this));
    }

    @Override
    public float interpolationFactor(Float value) {
        return CommonMath.notZero(this.length().floatValue()) ? (value.floatValue() - this.getMin().floatValue()) / this.length().floatValue() : 0.0f;
    }

    @Override
    public Float center() {
        return Float.valueOf(this.getMin().floatValue() + this.length().floatValue() * 0.5f);
    }

    @Override
    public Float length() {
        return Float.valueOf(this.getMax().floatValue() - this.getMin().floatValue());
    }

    public FloatBounds scale(float scale) {
        return FloatBounds.between(Float.valueOf(this.getMin().floatValue() * scale), Float.valueOf(this.getMax().floatValue() * scale));
    }

    public FloatBounds extend(Float value) {
        return FloatBounds.between(Float.valueOf(this.getMin().floatValue() - value.floatValue()), Float.valueOf(this.getMax().floatValue() + value.floatValue()));
    }

    public FloatBounds reduce(Float value) {
        return FloatBounds.between(Float.valueOf(this.getMin().floatValue() + value.floatValue()), Float.valueOf(this.getMax().floatValue() - value.floatValue()));
    }

    public FloatBounds offset(Float value) {
        return FloatBounds.between(Float.valueOf(this.getMin().floatValue() + value.floatValue()), Float.valueOf(this.getMax().floatValue() + value.floatValue()));
    }

    public FloatBounds fit(IBounds<Float> bounds) {
        return FloatBounds.between(bounds.enclose(this.getMin()), bounds.enclose(this.getMax()));
    }

    public String toString() {
        return FloatBounds.class.getSimpleName() + Args.group(Args.get("min", this.getMin()), Args.get("max", this.getMax()));
    }

    @Override
    public boolean randomFits(Float value) {
        if (value.floatValue() >= this.getMax().floatValue()) {
            return true;
        }
        if (value.floatValue() <= this.getMin().floatValue()) {
            return false;
        }
        Float random = this.randomBetween();
        return random.floatValue() <= value.floatValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatBounds) {
            FloatBounds bounds = (FloatBounds)obj;
            return this.getMin().equals(bounds.getMin()) && this.getMax().equals(bounds.getMax());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    @Override
    public boolean corners(Float value) {
        return this.getMin().equals(value) || this.getMax().equals(value);
    }

    public FloatBounds unite(IBounds<Float> bounds) {
        return FloatBounds.between(Float.valueOf(Math.min(this.getMin().floatValue(), bounds.getMin().floatValue())), Float.valueOf(Math.max(this.getMax().floatValue(), bounds.getMax().floatValue())));
    }
}

