/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface IPollutant {
    public boolean affectsPollutionLevel(LevelAccessor var1, BlockPos var2, BlockState var3);

    public boolean canPassThrough(LevelReader var1, BlockPos var2, Direction var3, Direction var4);

    public int getCarriedPollutionAmount(BlockState var1);

    public int getPollutionCapacity();

    public boolean pump(LevelAccessor var1, BlockPos var2);

    public int pump(LevelAccessor var1, BlockPos var2, int var3);

    public int pumpEntitiesAt(LevelAccessor var1, BlockPos var2, int var3);

    public boolean push(LevelAccessor var1, BlockPos var2, Direction var3);

    public boolean spend(LevelAccessor var1, BlockPos var2);

    public int spend(LevelAccessor var1, BlockPos var2, int var3);

    public Type getPollutantType();

    @Deprecated
    default public int pumpThroughActivePumps(Level level, List<BlockPos> pumps, int amount) {
        int count = 0;
        for (BlockPos pumpPos : pumps) {
            if (!GameWorld.SmokeContainers.isActivePump((LevelReader)level, pumpPos)) continue;
            List<BlockPos> around = GameWorld.Positions.getAroundHoriz(pumpPos, false, new BlockPos[0]);
            for (BlockPos pos : around) {
                if (GameWorld.SmokeContainers.isChimney((LevelReader)level, pos)) {
                    count += this.pumpEntitiesAt((LevelAccessor)level, pos, amount - count);
                }
                if (count < amount) continue;
                return count;
            }
            List<BlockPos> vents = GameWorld.SmokeContainers.getVentsAround((LevelReader)level, pumpPos);
            if ((count += this.pumpChimneysThroughVents(level, vents, amount - count)) >= amount) {
                return count;
            }
            for (BlockPos pos : around) {
                if ((count += this.pump((LevelAccessor)level, pos, amount - count)) < amount) continue;
                return count;
            }
            if ((count += this.pumpFreeSpacesThroughVents(level, vents, amount - count)) < amount) continue;
            return count;
        }
        return count;
    }

    @Deprecated
    default public int pumpChimneysThroughVents(Level level, List<BlockPos> vents, int amount) {
        return WorldSearch.VentPipe.pump((LevelAccessor)level, vents, amount, GameWorld.SmokeContainers::isChimney, this::pumpEntitiesAt);
    }

    @Deprecated
    default public int pumpFreeSpacesThroughVents(Level level, List<BlockPos> vents, int amount) {
        if (vents.isEmpty()) {
            return 0;
        }
        int count = 0;
        if (count >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((LevelAccessor)level, vents, amount - count, LevelReader::m_46859_, (w, pos, max) -> this.pump((LevelAccessor)level, pos, 1))) >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((LevelAccessor)level, vents, amount - count, (w, pos) -> true, this::pump)) >= amount) {
            return count;
        }
        count += WorldSearch.VentPipe.pump((LevelAccessor)level, vents, amount - count, (w, pos) -> this.canPassThrough((LevelReader)level, pos, Direction.DOWN, Direction.UP), this::pumpEntitiesAt);
        return count;
    }

    public static enum Type {
        AIR,
        WATER,
        SOIL;

    }
}

