/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class KeypadChestBlockEntity
extends ChestBlockEntity
implements IPasswordProtected,
IOwnable,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private String passcode;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private EnumMap<ModuleType, Boolean> moduleStates = new EnumMap(ModuleType.class);

    public KeypadChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        if (this.owner != null) {
            this.owner.save(tag, false);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.passcode = tag.m_128461_("passcode");
        this.owner.load(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_6820_() {
        return Utils.localize("block.securitycraft.keypad_chest", new Object[0]);
    }

    protected void m_142151_(Level level, BlockPos pos, BlockState state, int i, int j) {
        super.m_142151_(level, pos, state, i, j);
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            BlockUtils.updateIndirectNeighbors(level, pos, state.m_60734_(), Direction.DOWN);
        }
    }

    public int getNumPlayersUsing() {
        return this.f_155324_.m_155450_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    public LazyOptional<IItemHandler> getHandlerForSentry(Sentry entity) {
        if (entity.getOwner().owns(this)) {
            return super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.m_8020_(slot);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadChestBlock) {
            KeypadChestBlock block2 = (KeypadChestBlock)block;
            if (!this.isBlocked()) {
                block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, player);
            }
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (!this.f_58857_.f_46443_) {
            if (this.isBlocked()) {
                return;
            }
            if (this.getPassword() != null) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSWORD, this.f_58858_));
            } else if (this.getOwner().isOwner(player)) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSWORD, this.f_58858_));
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        this.activate(player);
        return true;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        this.addOrRemoveModuleFromAttached(stack, false, toggled);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        this.addOrRemoveModuleFromAttached(stack, true, toggled);
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
    }

    @Override
    public void onOptionChanged(Option<?> o) {
        if (o instanceof Option.BooleanOption) {
            Option.BooleanOption option = (Option.BooleanOption)o;
            KeypadChestBlockEntity offsetTe = this.findOther();
            if (offsetTe != null) {
                offsetTe.setSendsMessages((Boolean)option.get());
            }
        }
        ICustomizable.super.onOptionChanged(o);
    }

    @Override
    public void dropAllModules() {
        KeypadChestBlockEntity offsetBe = this.findOther();
        for (ItemStack module : this.getInventory()) {
            Item item = module.m_41720_();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem item2 = (ModuleItem)item;
            if (offsetBe != null) {
                offsetBe.removeModule(item2.getModuleType(), false);
            }
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove, boolean toggled) {
        Item item;
        if (module.m_41619_() || !((item = module.m_41720_()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        KeypadChestBlockEntity offsetBe = this.findOther();
        if (offsetBe != null) {
            if (toggled && offsetBe.isModuleEnabled(moduleItem.getModuleType()) != remove) {
                return;
            }
            if (!toggled && offsetBe.hasModule(moduleItem.getModuleType()) != remove) {
                return;
            }
            if (remove) {
                offsetBe.removeModule(moduleItem.getModuleType(), toggled);
            } else {
                offsetBe.insertModule(module, toggled);
            }
        }
    }

    public KeypadChestBlockEntity findOther() {
        BlockState state = this.m_58900_();
        ChestType type = (ChestType)state.m_61143_((Property)KeypadChestBlock.f_51479_);
        if (type != ChestType.SINGLE) {
            BlockEntity blockEntity;
            ChestType offsetType;
            BlockPos offsetPos = this.f_58858_.m_142300_(ChestBlock.m_51584_((BlockState)state));
            BlockState offsetState = this.f_58857_.m_8055_(offsetPos);
            if (state.m_60734_() == offsetState.m_60734_() && (offsetType = (ChestType)offsetState.m_61143_((Property)KeypadChestBlock.f_51479_)) != ChestType.SINGLE && type != offsetType && state.m_61143_((Property)KeypadChestBlock.f_51478_) == offsetState.m_61143_((Property)KeypadChestBlock.f_51478_) && (blockEntity = this.f_58857_.m_7702_(offsetPos)) instanceof KeypadChestBlockEntity) {
                KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
                return be;
            }
        }
        return null;
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        KeypadChestBlockEntity otherHalf = this.findOther();
        if (otherHalf != null) {
            otherHalf.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
        }
        IOwnable.super.onOwnerChanged(state, level, pos, player);
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.m_6596_();
    }

    public boolean isBlocked() {
        for (Direction dir : Direction.Plane.HORIZONTAL.m_122557_().collect(Collectors.toList())) {
            BlockPos pos = this.m_58899_().m_142300_(dir);
            if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof KeypadChestBlock) || !KeypadChestBlock.isBlocked(this.f_58857_, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return KeypadChestBlock.isBlocked(this.m_58904_(), this.m_58899_());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
        if (shouldBeEnabled) {
            this.onModuleInserted(this.getModule(module), module, true);
        } else {
            this.onModuleRemoved(this.getModule(module), module, true);
        }
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public void setSendsMessages(boolean value) {
        this.sendMessage.setValue(value);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.m_6596_();
    }
}

