/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            boolean toggled = (Boolean)parameters[2];
            this.insertModule(module, toggled);
            if (((ModuleItem)module.m_41720_()).getModuleType() == ModuleType.DISGUISE) {
                this.onInsertDisguiseModule(module, toggled);
            }
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            ItemStack moduleStack = this.getModule(module);
            boolean toggled = (Boolean)parameters[2];
            this.removeModule(module, toggled);
            if (module == ModuleType.DISGUISE) {
                this.onRemoveDisguiseModule(moduleStack, toggled);
            }
        } else if (action == LinkedAction.OWNER_CHANGED) {
            Owner owner = (Owner)parameters[0];
            this.setOwner(owner.getUUID(), owner.getName());
        }
        excludedBEs.add(this);
        this.createLinkedBlockAction(action, parameters, excludedBEs);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(stack, toggled);
        }
    }

    private void onInsertDisguiseModule(ItemStack stack, boolean toggled) {
        BlockState state = this.m_58900_();
        if (!this.f_58857_.f_46443_) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack, toggled));
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
            }
        } else {
            ClientHandler.putDisguisedBeRenderer(this, stack);
            if (state.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
            }
        }
    }

    private void onRemoveDisguiseModule(ItemStack stack, boolean toggled) {
        if (!this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack, toggled));
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
            }
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
            DisguisableBlock.getDisguisedBlockStateFromStack(stack).ifPresent(disguisedState -> {
                if (disguisedState.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                    this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
                }
            });
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.m_41619_()) {
                ClientHandler.putDisguisedBeRenderer(this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
            }
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_STATE_RL, (Object)Blocks.f_50016_.m_49966_()).build();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

