/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((SpecialDoorBlockEntity)this).m_58899_(), "signalLength", this.defaultSignalLength(), 0, 400, 5, true);

    public SpecialDoorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        SpecialDoorBlockEntity be;
        pos = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpecialDoorBlockEntity && SpecialDoorBlockEntity.isLinkedWith(this, be = (SpecialDoorBlockEntity)blockEntity)) {
            be.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.f_46443_) {
                level.m_142572_().m_6846_().m_11268_((Packet)be.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player);
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            if (option.getName().equals(this.sendMessage.getName())) {
                this.sendMessage.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
            }
            this.m_6596_();
        } else if (action == LinkedAction.MODULE_INSERTED) {
            this.insertModule((ItemStack)parameters[0], (Boolean)parameters[2]);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            this.removeModule((ModuleType)((Object)parameters[1]), (Boolean)parameters[2]);
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public abstract int defaultSignalLength();
}

