/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class IMSBlock
extends OwnableBlock {
    public static final IntegerProperty MINES = IntegerProperty.m_61631_((String)"mines", (int)0, (int)4);
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_1_MINE = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_2_MINES = Shapes.m_83110_((VoxelShape)SHAPE_1_MINE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)5.0, (double)16.0));
    private static final VoxelShape SHAPE_3_MINES = Shapes.m_83110_((VoxelShape)SHAPE_2_MINES, (VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_4_MINES = Shapes.m_83110_((VoxelShape)SHAPE_3_MINES, (VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0, (double)16.0));

    public IMSBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MINES, (Comparable)Integer.valueOf(4)));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)ConfigHandler.SERVER.ableToBreakMines.get() == false ? -1.0f : super.m_5880_(state, player, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Integer)state.m_61143_((Property)MINES)) {
            case 4 -> SHAPE_4_MINES;
            case 3 -> SHAPE_3_MINES;
            case 2 -> SHAPE_2_MINES;
            case 1 -> SHAPE_1_MINE;
            default -> SHAPE;
        };
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_46961_(pos, true);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!newState.m_155947_()) {
                level.m_46747_(pos);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        if (!level.f_46443_ && ((IOwnable)(be = level.m_7702_(pos))).getOwner().isOwner(player)) {
            ItemStack held = player.m_21120_(hand);
            int mines = (Integer)state.m_61143_((Property)MINES);
            if (held.m_41720_() == ((Block)SCContent.BOUNCING_BETTY.get()).m_5456_() && mines < 4) {
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)MINES, (Comparable)Integer.valueOf(mines + 1)));
                ((IMSBlockEntity)be).setBombsRemaining(mines + 1);
            } else {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.IMS, pos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)MINES) == 0) {
            double x = (double)((float)pos.m_123341_() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.m_123342_() + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.m_123343_() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, x, y, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123744_, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)ParticleTypes.f_123744_, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)this.m_49966_().m_61124_((Property)MINES, (Comparable)Integer.valueOf(4));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MINES});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IMSBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return IMSBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.IMS_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }
}

