/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class MineRemoteAccessToolItem
extends Item {
    public MineRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            ClientHandler.displayMRATScreen(player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), stack, ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_);
    }

    public InteractionResult onItemUseFirst(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        if (level.m_8055_(pos).m_60734_() instanceof IExplosive) {
            if (!this.isMineAdded(stack, pos)) {
                IOwnable ownable;
                int availSlot = this.getNextAvailableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof IOwnable && !(ownable = (IOwnable)blockEntity).getOwner().isOwner(player)) {
                    if (level.f_46443_) {
                        ClientHandler.displayMRATScreen(stack);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128385_("mine" + availSlot, BlockUtils.posToIntArray(pos));
                if (!level.f_46443_) {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
                }
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                return InteractionResult.SUCCESS;
            }
            this.removeTagFromItemAndUpdate(stack, pos, player);
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3) {
                list.add((Component)new TextComponent(ChatFormatting.GRAY + "---"));
                continue;
            }
            list.add((Component)Utils.localize("tooltip.securitycraft:mine", new Object[0]).m_7220_((Component)new TextComponent(" " + i + ": ")).m_7220_((Component)Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]))).m_6270_(Utils.GRAY_STYLE));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, Player player) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128473_("mine" + i);
            if (!player.f_19853_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return;
        }
    }

    private boolean isMineAdded(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvailableSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 1;
        }
        for (int i = 1; i <= 6; ++i) {
            if (stack.m_41783_().m_128465_("mine" + i).length == 3) continue;
            return i;
        }
        return 0;
    }
}

