/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class SonicSecuritySystemItem
extends BlockItem {
    public SonicSecuritySystemItem(Item.Properties properties) {
        super((Block)SCContent.SONIC_SECURITY_SYSTEM.get(), properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), stack, ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_);
    }

    public InteractionResult onItemUseFirst(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        BlockEntity be;
        if (!level.f_46443_ && !player.m_6144_() && (be = level.m_7702_(pos)) instanceof ILockable) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).getOwner().isOwner(player)) {
                DisguisableBlock disguisable;
                Block block = be.m_58900_().m_60734_();
                if (!(block instanceof DisguisableBlock) || (disguisable = (DisguisableBlock)block).getDisguisedBlockState((BlockGetter)level, pos) == null) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:notOwned", ownable.getOwner().getName()), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                if (SonicSecuritySystemItem.isAdded(stack.m_41783_(), pos)) {
                    SonicSecuritySystemItem.removeLinkedBlock(stack.m_41783_(), pos);
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", Utils.localize(level.m_8055_(pos).m_60734_().m_7705_(), new Object[0]), pos), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
                if (SonicSecuritySystemItem.addLinkedBlock(stack.m_41783_(), pos, player)) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", Utils.localize(level.m_8055_(pos).m_60734_().m_7705_(), new Object[0]), pos), ChatFormatting.GREEN);
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!stack.m_41782_() || !SonicSecuritySystemItem.hasLinkedBlock(stack.m_41783_())) {
            if (!level.f_46443_) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), ChatFormatting.DARK_RED);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).transferPositionsFromItem(stack.m_41784_())) {
            return true;
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        int numOfLinkedBlocks = stack.m_41783_().m_128437_("LinkedBlocks", 10).size();
        if (numOfLinkedBlocks > 0) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).m_130948_(Utils.GRAY_STYLE));
        }
    }

    public static boolean addLinkedBlock(CompoundTag tag, BlockPos pos, Player player) {
        if (SonicSecuritySystemItem.isAdded(tag, pos)) {
            return false;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        if (list.size() >= 30) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), ChatFormatting.DARK_RED);
            return false;
        }
        CompoundTag nbt = NbtUtils.m_129224_((BlockPos)pos);
        list.add((Object)nbt);
        tag.m_128365_("LinkedBlocks", (Tag)list);
        return true;
    }

    public static void removeLinkedBlock(CompoundTag tag, BlockPos pos) {
        if (!tag.m_128441_("LinkedBlocks")) {
            return;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        for (int i = list.size() - 1; i >= 0; --i) {
            BlockPos posRead = NbtUtils.m_129239_((CompoundTag)list.m_128728_(i));
            if (!pos.equals((Object)posRead)) continue;
            list.remove(i);
        }
    }

    public static boolean isAdded(CompoundTag tag, BlockPos pos) {
        if (!tag.m_128441_("LinkedBlocks")) {
            return false;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos posRead = NbtUtils.m_129239_((CompoundTag)list.m_128728_(i));
            if (!pos.equals((Object)posRead)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkedBlock(CompoundTag tag) {
        if (!tag.m_128441_("LinkedBlocks")) {
            return false;
        }
        return tag.m_128437_("LinkedBlocks", 10).size() > 0;
    }
}

