/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class ChunkMapMixin {
    @Shadow
    int f_140126_;

    @Shadow
    protected abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Shadow
    public abstract List<ServerPlayer> m_183262_(ChunkPos var1, boolean var2);

    @Inject(method={"setViewDistance"}, at={@At(value="NEW", target="org/apache/commons/lang3/mutable/MutableObject", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void updateAccordingToCamera(int viewDistance, CallbackInfo callback, int i, int j, ObjectIterator<?> objectIterator, ChunkHolder chunkHolder, ChunkPos chunkPos) {
        MutableObject mutableObject = new MutableObject();
        this.m_183262_(chunkPos, false).forEach(player -> {
            SectionPos sectionPos = PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) ? SectionPos.m_123194_((Entity)player.m_8954_()) : player.m_8965_();
            boolean flag = ChunkMap.m_200878_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (int)sectionPos.m_123170_(), (int)sectionPos.m_123222_(), (int)j);
            boolean flag1 = ChunkMap.m_200878_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (int)sectionPos.m_123170_(), (int)sectionPos.m_123222_(), (int)viewDistance);
            this.m_183754_((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)mutableObject, flag, flag1);
        });
        callback.cancel();
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void trackCameraLoadedChunks(ServerPlayer player, CallbackInfo callback) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SectionPos pos = SectionPos.m_123194_((Entity)player.m_8954_());
            SecurityCamera camera = (SecurityCamera)player.m_8954_();
            for (int i = pos.m_123170_() - this.f_140126_; i <= pos.m_123170_() + this.f_140126_; ++i) {
                for (int j = pos.m_123222_() - this.f_140126_; j <= pos.m_123222_() + this.f_140126_; ++j) {
                    this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), camera.hasLoadedChunks(), true);
                }
            }
            camera.setHasLoadedChunks(this.f_140126_);
        }
    }
}

