/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.TriPredicate;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    private final TriPredicate<ProjectorBlockEntity, Boolean, Integer> yLoopBoundary = (be, hanging, y) -> hanging.booleanValue() ? y > -be.getProjectionHeight() : y < be.getProjectionHeight();

    public ProjectorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ProjectorBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay);
        if (be.isActive() && !be.m_7983_()) {
            BlockState state = be.getProjectedState();
            boolean hanging = (Boolean)be.m_58900_().m_61143_((Property)ProjectorBlock.HANGING);
            RenderSystem.m_69464_();
            for (int x = 0; x < be.getProjectionWidth(); ++x) {
                int y = 0;
                while (this.yLoopBoundary.test((Object)be, (Object)hanging, (Object)y)) {
                    pose.m_85836_();
                    BlockPos pos = !be.isHorizontal() ? this.translateProjection(be.m_58899_(), pose, (Direction)be.m_58900_().m_61143_((Property)ProjectorBlock.FACING), x, y, be.getProjectionRange(), be.getProjectionOffset()) : this.translateProjection(be.m_58899_(), pose, (Direction)be.m_58900_().m_61143_((Property)ProjectorBlock.FACING), x, be.getProjectionRange() - 16, y + 1, be.getProjectionOffset());
                    if (pos != null && be.m_58904_().m_46859_(pos)) {
                        for (RenderType renderType : RenderType.m_110506_()) {
                            if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)renderType)) continue;
                            Minecraft.m_91087_().m_91289_().m_110924_(state, pos, (BlockAndTintGetter)be.m_58904_(), pose, buffer.m_6299_(renderType), true, be.m_58904_().f_46441_);
                        }
                        ClientHandler.PROJECTOR_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay);
                    }
                    pose.m_85849_();
                    y = hanging ? y - 1 : y + 1;
                }
            }
            RenderSystem.m_69481_();
        }
    }

    private BlockPos translateProjection(BlockPos bePos, PoseStack pose, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos = null;
        if (direction == Direction.NORTH) {
            pos = new BlockPos((double)(bePos.m_123341_() + x) + offset, (double)(bePos.m_123342_() + y), (double)bePos.m_123343_() + distance);
            pose.m_85837_(0.0 + (double)x + offset, 0.0 + (double)y, distance);
        } else if (direction == Direction.SOUTH) {
            pos = new BlockPos((double)(bePos.m_123341_() + x) + offset, (double)(bePos.m_123342_() + y), (double)bePos.m_123343_() + -distance);
            pose.m_85837_(0.0 + (double)x + offset, 0.0 + (double)y, -distance);
        } else if (direction == Direction.WEST) {
            pos = new BlockPos((double)bePos.m_123341_() + distance, (double)(bePos.m_123342_() + y), (double)(bePos.m_123343_() + x) + offset);
            pose.m_85837_(distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        } else if (direction == Direction.EAST) {
            pos = new BlockPos((double)bePos.m_123341_() + -distance, (double)(bePos.m_123342_() + y), (double)(bePos.m_123343_() + x) + offset);
            pose.m_85837_(-distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        }
        return pos;
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity be) {
        return true;
    }
}

