/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final TranslatableComponent selectCameras = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]);
    private Inventory playerInventory;
    private CameraMonitorItem cameraMonitor;
    private CompoundTag nbtTag;
    private CameraButton[] cameraButtons = new CameraButton[10];
    private CameraButton[] unbindButtons = new CameraButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private SecurityCameraBlockEntity[] cameraBEs = new SecurityCameraBlockEntity[10];
    private ResourceLocation[] cameraViewDim = new ResourceLocation[10];
    private int xSize = 176;
    private int ySize = 166;
    private int page = 1;

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag) {
        super((Component)new TranslatableComponent(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_()));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void m_7856_() {
        int i;
        super.m_7856_();
        Button prevPageButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 68, this.f_96544_ / 2 + 40, 20, 20, (Component)new TextComponent("<"), b -> this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1))));
        Button nextPageButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 52, this.f_96544_ / 2 + 40, 20, 20, (Component)new TextComponent(">"), b -> this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1))));
        TextComponent x = new TextComponent("x");
        this.cameraButtons[0] = new CameraButton(1, this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 60 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[1] = new CameraButton(2, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 60 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[2] = new CameraButton(3, this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 60 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[3] = new CameraButton(4, this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 30 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[4] = new CameraButton(5, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 30 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[5] = new CameraButton(6, this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 30 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[6] = new CameraButton(7, this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[7] = new CameraButton(8, this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[8] = new CameraButton(9, this.f_96543_ / 2 + 22, this.f_96544_ / 2 + 10, 20, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.cameraButtons[9] = new CameraButton(10, this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 40, 80, 20, TextComponent.f_131282_, this::cameraButtonClicked);
        this.unbindButtons[0] = new CameraButton(1, this.f_96543_ / 2 - 19, this.f_96544_ / 2 - 68 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[1] = new CameraButton(2, this.f_96543_ / 2 + 11, this.f_96544_ / 2 - 68 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[2] = new CameraButton(3, this.f_96543_ / 2 + 41, this.f_96544_ / 2 - 68 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[3] = new CameraButton(4, this.f_96543_ / 2 - 19, this.f_96544_ / 2 - 38 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[4] = new CameraButton(5, this.f_96543_ / 2 + 11, this.f_96544_ / 2 - 38 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[5] = new CameraButton(6, this.f_96543_ / 2 + 41, this.f_96544_ / 2 - 38 + 10, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[6] = new CameraButton(7, this.f_96543_ / 2 - 19, this.f_96544_ / 2 + 2, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[7] = new CameraButton(8, this.f_96543_ / 2 + 11, this.f_96544_ / 2 + 2, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[8] = new CameraButton(9, this.f_96543_ / 2 + 41, this.f_96544_ / 2 + 2, 8, 8, (Component)x, this::unbindButtonClicked);
        this.unbindButtons[9] = new CameraButton(10, this.f_96543_ / 2 + 41, this.f_96544_ / 2 + 32, 8, 8, (Component)x, this::unbindButtonClicked);
        for (i = 0; i < 10; ++i) {
            CameraButton button = this.cameraButtons[i];
            int camID = button.camId + (this.page - 1) * 10;
            ArrayList<GlobalPos> views = this.cameraMonitor.getCameraPositions(this.nbtTag);
            GlobalPos view = views.get(camID - 1);
            button.m_93666_((Component)button.m_6035_().m_6879_().m_7220_((Component)new TextComponent("" + camID)));
            this.m_142416_((GuiEventListener)button);
            if (view != null) {
                SecurityCameraBlockEntity camera;
                BlockEntity blockEntity;
                if (!view.m_122640_().equals((Object)Minecraft.m_91087_().f_91074_.f_19853_.m_46472_())) {
                    this.hoverCheckers[button.camId - 1] = new HoverChecker((AbstractWidget)button);
                    this.cameraViewDim[button.camId - 1] = view.m_122640_().m_135782_();
                }
                this.cameraBEs[button.camId - 1] = (blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(view.m_122646_())) instanceof SecurityCameraBlockEntity ? (camera = (SecurityCameraBlockEntity)blockEntity) : null;
                this.hoverCheckers[button.camId - 1] = new HoverChecker((AbstractWidget)button);
                continue;
            }
            button.f_93623_ = false;
            this.unbindButtons[button.camId - 1].f_93623_ = false;
            this.cameraBEs[button.camId - 1] = null;
        }
        for (i = 0; i < 10; ++i) {
            this.m_142416_((GuiEventListener)this.unbindButtons[i]);
        }
        if (this.page == 1) {
            prevPageButton.f_93623_ = false;
        }
        if (this.page == 3 || this.cameraMonitor.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            nextPageButton.f_93623_ = false;
        }
        for (i = this.cameraMonitor.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].f_93623_ = false;
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, (Component)this.selectCameras, (float)(startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.selectCameras) / 2), (float)(startY + 6), 0x404040);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY) || this.cameraBEs[i] == null || !this.cameraBEs[i].m_8077_()) continue;
            this.m_96617_(pose, this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:monitor.cameraName", this.cameraBEs[i].m_7770_()), 150), mouseX, mouseY);
        }
    }

    private void cameraButtonClicked(Button button) {
        int camID = ((CameraButton)button).camId + (this.page - 1) * 10;
        SecurityCraft.channel.sendToServer((Object)new MountCamera(this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1).m_122646_()));
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    private void unbindButtonClicked(Button button) {
        int camID = ((CameraButton)button).camId + (this.page - 1) * 10;
        SecurityCraft.channel.sendToServer((Object)new RemoveCameraTag(PlayerUtils.getSelectedItemStack(this.playerInventory, (Item)SCContent.CAMERA_MONITOR.get()), camID));
        this.nbtTag.m_128473_(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1)));
        button.f_93623_ = false;
        this.cameraButtons[(camID - 1) % 10].f_93623_ = false;
    }

    public boolean m_7043_() {
        return false;
    }

    private static class CameraButton
    extends ExtendedButton {
        private final int camId;

        public CameraButton(int camId, int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
            super(xPos, yPos, width, height, displayString, handler);
            this.camId = camId;
        }
    }
}

