/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CheckPasswordScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private BlockEntity be;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private TranslatableComponent blockName;
    private EditBox keycodeTextbox;
    private String currentString = "";
    private static final int MAX_CHARS = 20;

    public CheckPasswordScreen(BlockEntity be, Component title) {
        super(title);
        this.be = be;
        this.blockName = Utils.localize(be.m_58900_().m_60734_().m_7705_(), new Object[0]);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 30 + 10, 80, 20, (Component)new TextComponent("0"), b -> this.addNumberToString(0)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 60 + 10, 20, 20, (Component)new TextComponent("1"), b -> this.addNumberToString(1)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 60 + 10, 20, 20, (Component)new TextComponent("2"), b -> this.addNumberToString(2)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 60 + 10, 20, 20, (Component)new TextComponent("3"), b -> this.addNumberToString(3)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 30 + 10, 20, 20, (Component)new TextComponent("4"), b -> this.addNumberToString(4)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 30 + 10, 20, 20, (Component)new TextComponent("5"), b -> this.addNumberToString(5)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 30 + 10, 20, 20, (Component)new TextComponent("6"), b -> this.addNumberToString(6)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 10, 20, 20, (Component)new TextComponent("7"), b -> this.addNumberToString(7)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 10, 20, 20, (Component)new TextComponent("8"), b -> this.addNumberToString(8)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 22, this.f_96544_ / 2 + 10, 20, 20, (Component)new TextComponent("9"), b -> this.addNumberToString(9)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 48, this.f_96544_ / 2 + 30 + 10, 25, 20, (Component)new TextComponent("<-"), b -> this.removeLastCharacter()));
        this.keycodeTextbox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 67, 77, 12, TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.keycodeTextbox);
        this.keycodeTextbox.m_94199_(20);
        this.keycodeTextbox.m_94153_(s -> s.matches("[0-9]*\\**"));
        this.m_94718_((GuiEventListener)this.keycodeTextbox);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pose, mouseX, mouseY, partialTick);
        this.f_96547_.m_92889_(pose, (Component)this.blockName, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.blockName) / 2), (float)(this.topPos + 6), 0x404040);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.currentString.length() > 0) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12490_, 0.15f, 1.0f);
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.isValidChar(typedChar) || this.currentString.length() >= 20) {
            return super.m_5534_(typedChar, keyCode);
        }
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12490_, 0.15f, 1.0f);
        this.currentString = this.currentString + typedChar;
        this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        this.checkCode(this.currentString);
        return true;
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    private void addNumberToString(int number) {
        if (this.currentString.length() < 20) {
            this.currentString = this.currentString + number;
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
        }
    }

    private void removeLastCharacter() {
        if (this.currentString.length() > 0) {
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        }
    }

    private void setTextboxCensoredText(EditBox textField, String text) {
        Object x = "";
        for (int i = 1; i <= text.length(); ++i) {
            x = (String)x + "*";
        }
        textField.m_94144_((String)x);
    }

    public void checkCode(String code) {
        SecurityCraft.channel.sendToServer((Object)new CheckPassword(this.be.m_58899_().m_123341_(), this.be.m_58899_().m_123342_(), this.be.m_58899_().m_123343_(), code));
    }
}

