/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.ScrollPanel;

public class TrophySystemScreen
extends Screen {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    private final TranslatableComponent projectiles = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]);
    private final TranslatableComponent moduleRequired = Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]);
    private final TranslatableComponent toggle = Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]);
    private final TranslatableComponent moddedProjectiles = Utils.localize("gui.securitycraft:trophy_system.moddedProjectiles", new Object[0]);
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private final boolean isSmart;
    private final List<EntityType<?>> orderedFilterList;
    private TrophySystemBlockEntity be;
    private ProjectileScrollList projectileList;

    public TrophySystemScreen(TrophySystemBlockEntity be) {
        super((Component)new TranslatableComponent(((Block)SCContent.TROPHY_SYSTEM.get()).m_7705_()));
        this.be = be;
        this.isSmart = be.isModuleEnabled(ModuleType.SMART);
        this.orderedFilterList = new ArrayList(be.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == EntityType.f_20510_) {
                return 1;
            }
            if (e2 == EntityType.f_20510_) {
                return -1;
            }
            return e1.m_20676_().getString().compareTo(e2.m_20676_().getString());
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.projectileList = new ProjectileScrollList(this.f_96541_, this.imageWidth - 24, this.imageHeight - 60, this.topPos + 40, this.leftPos + 12);
        this.m_142416_((GuiEventListener)this.projectileList);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
        this.f_96547_.m_92889_(pose, (Component)this.projectiles, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.projectiles) / 2), (float)(this.topPos + 31), 0x404040);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, (Component)this.toggle, (Component)this.moduleRequired, this.isSmart, this.leftPos + 5, this.topPos + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.projectileList != null) {
            this.projectileList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    class ProjectileScrollList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength;

        public ProjectileScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = TrophySystemScreen.this.orderedFilterList.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(TrophySystemScreen.this.f_96547_);
            int height = 50 + this.listLength * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12;
            if (TrophySystemScreen.this.isSmart && slotIndex >= 0 && mouseY >= 0.0 && slotIndex < this.listLength) {
                TrophySystemScreen.this.be.toggleFilter(TrophySystemScreen.this.orderedFilterList.get(slotIndex));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return false;
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (TrophySystemScreen.this.isSmart && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                BufferBuilder bufferBuilder = tess.m_85915_();
                RenderSystem.m_69478_();
                RenderSystem.m_69472_();
                RenderSystem.m_69453_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
                RenderSystem.m_69493_();
                RenderSystem.m_69461_();
            }
            int i = 0;
            for (EntityType<?> projectileType : TrophySystemScreen.this.orderedFilterList) {
                Component projectileName = projectileType == EntityType.f_20510_ ? TrophySystemScreen.this.moddedProjectiles : projectileType.m_20676_();
                int yStart = relativeY + 12 * i;
                TrophySystemScreen.this.f_96547_.m_92889_(pose, projectileName, (float)(this.left + this.width / 2 - TrophySystemScreen.this.f_96547_.m_92852_((FormattedText)projectileName) / 2), (float)yStart, 0xC6C6C6);
                RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
                ProjectileScrollList.m_93160_((PoseStack)pose, (int)this.left, (int)(yStart - 3), (int)14, (int)14, (float)(TrophySystemScreen.this.be.getFilter(projectileType) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
                ++i;
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

