/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityRenderDelegate {
    private final Map<BlockEntity, DelegateRendererInfo> renderDelegates = new HashMap<BlockEntity, DelegateRendererInfo>();

    public void putDelegateFor(BlockEntity originalBlockEntity, BlockState delegateState) {
        if (this.renderDelegates.containsKey(originalBlockEntity)) {
            DelegateRendererInfo delegateInfo = this.renderDelegates.get(originalBlockEntity);
            if (delegateInfo.delegateBlockEntity.m_58900_().m_60734_() == delegateState.m_60734_()) {
                delegateInfo.delegateBlockEntity.m_155250_(delegateState);
                return;
            }
        }
        if (delegateState != null && delegateState.m_155947_()) {
            Minecraft mc = Minecraft.m_91087_();
            BlockEntity delegateBe = ((EntityBlock)delegateState.m_60734_()).m_142194_(BlockPos.f_121853_, delegateState);
            delegateBe.m_142339_((Level)mc.f_91073_);
            BlockEntityRenderer delegateBeRenderer = mc.m_167982_().m_112265_(delegateBe);
            if (delegateBeRenderer != null) {
                this.renderDelegates.put(originalBlockEntity, new DelegateRendererInfo(delegateBe, delegateBeRenderer));
            }
        }
    }

    public void removeDelegateOf(BlockEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity);
    }

    public boolean tryRenderDelegate(BlockEntity originalBlockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalBlockEntity);
        if (delegateRendererInfo != null) {
            delegateRendererInfo.delegateRenderer().m_6922_(delegateRendererInfo.delegateBlockEntity(), partialTicks, pose, buffer, combinedLight, combinedOverlay);
            return true;
        }
        return false;
    }

    private record DelegateRendererInfo(BlockEntity delegateBlockEntity, BlockEntityRenderer delegateRenderer) {
    }
}

