/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import net.dark_roleplay.marg.MargClient;
import net.dark_roleplay.marg.common.listeners.TextProcessorsReloadListener;
import net.dark_roleplay.marg.common.material.MaterialLoader;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="marg")
public class Marg {
    private static final Path RESOURCE_PATH = Paths.get("./mod_data/marg/resource_pack/assets/", new String[0]);
    private static final Path DATA_PATH = Paths.get("./mod_data/marg/data_pack/data/", new String[0]);
    public static final String MODID = "marg";
    public static final Logger LOGGER = LogManager.getLogger();

    public Marg() {
        MaterialLoader.loadMaterialFiles();
        try {
            this.generateFolders();
            this.extractPackMeta();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MargClient::clientConstructor);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::addReloadListener);
    }

    public void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new TextProcessorsReloadListener(LogicalSide.SERVER));
    }

    public void extractPackMeta() throws IOException {
        Path metaTemplate = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"pack.mcmeta"});
        Files.copy(metaTemplate, Paths.get(RESOURCE_PATH.getParent().toString(), "pack.mcmeta"), new CopyOption[0]);
        Files.copy(metaTemplate, Paths.get(DATA_PATH.getParent().toString(), "pack.mcmeta"), new CopyOption[0]);
    }

    public void generateFolders() throws IOException {
        ArrayList<Path> resourcePacks = new ArrayList<Path>();
        ArrayList<Path> dataPacks = new ArrayList<Path>();
        resourcePacks.add(RESOURCE_PATH);
        dataPacks.add(DATA_PATH);
        ModList.get().getMods().forEach(info -> {
            Map props = info.getModProperties();
            try {
                boolean hasAssets;
                boolean bl = hasAssets = props.containsKey("hasMargAssets") && (Boolean)props.get("hasMargAssets") != false;
                if (hasAssets) {
                    resourcePacks.add(Paths.get("./mod_data/marg/resource_pack/assets/", info.getModId()));
                }
            }
            catch (Exception e) {
                LOGGER.error("{} provided invalid value for '{}', expected a boolaen but found a {}", (Object)info.getModId(), (Object)"hasMargAssets", props.get("hasMargAssets"));
            }
            try {
                boolean hasData;
                boolean bl = hasData = props.containsKey("hasMargDatas") && (Boolean)props.get("hasMargDatas") != false;
                if (hasData) {
                    resourcePacks.add(Paths.get("./mod_data/marg/data_pack/data/", info.getModId()));
                }
            }
            catch (Exception e) {
                LOGGER.error("{} provided invalid value for '{}', expected a boolaen but found a {}", (Object)info.getModId(), (Object)"hasMargDatas", props.get("hasMargDatas"));
            }
        });
        for (Path p : resourcePacks) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        for (Path p : dataPacks) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
    }
}

