/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.api.materials;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialType;

public final class MaterialRegistry {
    private static MaterialRegistry INSTANCE = new MaterialRegistry();
    private Map<String, MaterialType> MATERIAL_TYPES = new HashMap<String, MaterialType>();
    private List<MargMaterial> MATERIAL_LIST;

    public static MaterialRegistry getInstance() {
        return INSTANCE;
    }

    private MaterialRegistry() {
    }

    public MaterialType getMaterialType(String typeName) {
        return this.MATERIAL_TYPES.get(typeName);
    }

    public void registerMaterial(MargMaterial material) {
        MaterialType type = this.MATERIAL_TYPES.computeIfAbsent(material.getMaterialType(), name -> new MaterialType((String)name));
        type.addMaterial(material);
    }

    public List<MargMaterial> getMaterials() {
        return this.MATERIAL_LIST == null ? (this.MATERIAL_LIST = this.MATERIAL_TYPES.values().stream().flatMap(type -> type.getMaterials().stream()).collect(Collectors.toList())) : this.MATERIAL_LIST;
    }
}

