/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.texture;

import java.util.function.BiFunction;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessorData;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureAnimationData;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureData;
import net.minecraft.resources.ResourceLocation;

public class TextureHolder {
    private ResourceLocation textureLocation;
    private TextureData[] textureData;
    private TextureAnimationData animationData;

    public TextureHolder(ResourceLocation location, TextureData[] textureData, TextureAnimationData animationData) {
        this.textureLocation = location;
        this.textureData = textureData;
        this.animationData = animationData;
    }

    public int frameCount() {
        return this.textureData.length;
    }

    public void applyProcessor(BiFunction<TextureData, TextureProcessorData, TextureData> processor, TextureProcessorData data) {
        data.setTextureDataIndex(0);
        TextureHolder input = data.getTexture();
        if (input == null || this.frameCount() == input.frameCount()) {
            for (int i = 0; i < this.textureData.length; ++i) {
                data.setTextureDataIndex(i);
                this.textureData[i] = processor.apply(this.textureData[i], data);
            }
        } else if (this.frameCount() > input.frameCount()) {
            for (int i = 0; i < this.textureData.length; ++i) {
                this.textureData[i] = processor.apply(this.textureData[i], data);
            }
        } else if (this.frameCount() < input.frameCount()) {
            TextureData[] newTextureData = new TextureData[input.frameCount()];
            for (int i = 0; i < newTextureData.length; ++i) {
                data.setTextureDataIndex(i);
                newTextureData[i] = processor.apply(this.textureData[0].clone(), data);
            }
            this.animationData.setFrametime(input.animationData.getFrametime());
            this.animationData.setInterpolate(input.animationData.isInterpolate());
            this.textureData = newTextureData;
        }
    }

    public TextureData[] getTextureData() {
        return this.textureData;
    }

    public TextureAnimationData getAnimationData() {
        return this.animationData;
    }

    public TextureHolder clone() {
        TextureData[] clonedTextureData = new TextureData[this.textureData.length];
        for (int i = 0; i < this.textureData.length; ++i) {
            clonedTextureData[i] = this.textureData[i].clone();
        }
        return new TextureHolder(this.textureLocation, clonedTextureData, this.animationData.clone());
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

