/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.common.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.dark_roleplay.marg.api.materials.MaterialRegistry;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialType;

public class MaterialCondition
implements Iterable<MargMaterial> {
    private static List<String> EMPTY = Collections.EMPTY_LIST;
    public static Codec<MaterialCondition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("materialType").forGetter(MaterialCondition::getTypeName), (App)Codec.STRING.listOf().optionalFieldOf("textures", EMPTY).forGetter(MaterialCondition::getTextures), (App)Codec.STRING.listOf().optionalFieldOf("items", EMPTY).forGetter(MaterialCondition::getItems), (App)Codec.STRING.listOf().optionalFieldOf("blocks", EMPTY).forGetter(MaterialCondition::getBlocks)).apply((Applicative)i, MaterialCondition::new));
    private final String typeName;
    private final List<String> textures;
    private final List<String> items;
    private final List<String> blocks;
    private MaterialType type;

    public MaterialCondition(String type, List<String> textures, List<String> items, List<String> blocks) {
        this.typeName = type;
        this.textures = textures;
        this.items = items;
        this.blocks = blocks;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getTextures() {
        return this.textures;
    }

    public List<String> getItems() {
        return this.items;
    }

    public List<String> getBlocks() {
        return this.blocks;
    }

    public MaterialType getType() {
        return this.type != null ? this.type : (this.type = MaterialRegistry.getInstance().getMaterialType(this.typeName));
    }

    @Override
    public Iterator<MargMaterial> iterator() {
        return this.getType().getMaterials().stream().filter(this::isValidMaterial).collect(Collectors.toList()).iterator();
    }

    private boolean isValidMaterial(MargMaterial material) {
        for (String tex : this.textures) {
            if (material.getTextureProvider().getTextures().containsKey(tex)) continue;
            return false;
        }
        for (String item : this.items) {
            if (material.getItems().containsKey(item)) continue;
            return false;
        }
        for (String block : this.blocks) {
            if (material.getBlocks().containsKey(block)) continue;
            return false;
        }
        return true;
    }
}

