/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.common.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.dark_roleplay.marg.util.MaterialColorHelper;
import net.minecraft.world.level.material.MaterialColor;

public class MaterialProperties {
    public static final Codec<MaterialProperties> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.optionalFieldOf("resistance", (Object)Float.valueOf(0.0f)).forGetter(MaterialProperties::getResistance), (App)Codec.FLOAT.optionalFieldOf("hardness", (Object)Float.valueOf(0.0f)).forGetter(MaterialProperties::getHardness), (App)Codec.INT.optionalFieldOf("harvestLevel", (Object)0).forGetter(MaterialProperties::getHarvestLevel), (App)Codec.FLOAT.optionalFieldOf("slipperiness", (Object)Float.valueOf(0.6f)).forGetter(MaterialProperties::getSlipperiness), (App)Codec.INT.optionalFieldOf("lightValue", (Object)0).forGetter(MaterialProperties::getLightValue), (App)Codec.STRING.listOf().optionalFieldOf("harvestTools", new ArrayList()).forGetter(MaterialProperties::getHarvestTools), (App)MaterialColorHelper.MATERIAL_COLOR.optionalFieldOf("mapColor", (Object)MaterialColor.f_76398_).forGetter(MaterialProperties::getMapColor)).apply((Applicative)i, MaterialProperties::new));
    private float resistance;
    private float hardness;
    private int harvestLevel;
    private List<String> harvestTools;
    private MaterialColor mapColor;
    private float slipperiness = 0.6f;
    private int lightValue;

    public MaterialProperties(Float resistance, Float hardness, Integer harvestLevel, float slipperiness, int lightValue, List<String> harvestTools, MaterialColor mapColor) {
        this.resistance = resistance.floatValue();
        this.hardness = hardness.floatValue();
        this.harvestLevel = harvestLevel;
        this.harvestTools = harvestTools;
        this.mapColor = mapColor;
        this.slipperiness = slipperiness;
        this.lightValue = lightValue;
    }

    public float getResistance() {
        return this.resistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public List<String> getHarvestTools() {
        return this.harvestTools;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    public float getSlipperiness() {
        return this.slipperiness;
    }

    public int getLightValue() {
        return this.lightValue;
    }
}

