/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.world.level.material.MaterialColor;

public class MaterialColorHelper {
    private static BiMap<String, MaterialColor> COLORS = HashBiMap.create((int)64);
    private static BiMap<MaterialColor, String> COLORS_INV;
    public static final Codec<MaterialColor> MATERIAL_COLOR;

    private static MaterialColor getColor(String name) {
        MaterialColor color = (MaterialColor)COLORS.get((Object)name);
        return color == null ? MaterialColor.f_76398_ : color;
    }

    private static String getColorName(MaterialColor color) {
        String colorName = (String)COLORS_INV.get((Object)color);
        return colorName == null ? "air" : colorName;
    }

    static {
        MATERIAL_COLOR = Codec.STRING.comapFlatMap(DataResult.partialGet(MaterialColorHelper::getColor, () -> "Unknown material color"), MaterialColorHelper::getColorName);
        COLORS.put((Object)"air", (Object)MaterialColor.f_76398_);
        COLORS.put((Object)"grass", (Object)MaterialColor.f_76399_);
        COLORS.put((Object)"sand", (Object)MaterialColor.f_76400_);
        COLORS.put((Object)"wool", (Object)MaterialColor.f_76401_);
        COLORS.put((Object)"tnt", (Object)MaterialColor.f_76402_);
        COLORS.put((Object)"ice", (Object)MaterialColor.f_76403_);
        COLORS.put((Object)"iron", (Object)MaterialColor.f_76404_);
        COLORS.put((Object)"foliage", (Object)MaterialColor.f_76405_);
        COLORS.put((Object)"snow", (Object)MaterialColor.f_76406_);
        COLORS.put((Object)"clay", (Object)MaterialColor.f_76407_);
        COLORS.put((Object)"dirt", (Object)MaterialColor.f_76408_);
        COLORS.put((Object)"stone", (Object)MaterialColor.f_76409_);
        COLORS.put((Object)"water", (Object)MaterialColor.f_76410_);
        COLORS.put((Object)"wood", (Object)MaterialColor.f_76411_);
        COLORS.put((Object)"quartz", (Object)MaterialColor.f_76412_);
        COLORS.put((Object)"adobe", (Object)MaterialColor.f_76413_);
        COLORS.put((Object)"magenta", (Object)MaterialColor.f_76414_);
        COLORS.put((Object)"light_blue", (Object)MaterialColor.f_76415_);
        COLORS.put((Object)"yellow", (Object)MaterialColor.f_76416_);
        COLORS.put((Object)"lime", (Object)MaterialColor.f_76417_);
        COLORS.put((Object)"pink", (Object)MaterialColor.f_76418_);
        COLORS.put((Object)"gray", (Object)MaterialColor.f_76419_);
        COLORS.put((Object)"light_gray", (Object)MaterialColor.f_76420_);
        COLORS.put((Object)"cyan", (Object)MaterialColor.f_76421_);
        COLORS.put((Object)"purple", (Object)MaterialColor.f_76422_);
        COLORS.put((Object)"blue", (Object)MaterialColor.f_76361_);
        COLORS.put((Object)"brown", (Object)MaterialColor.f_76362_);
        COLORS.put((Object)"green", (Object)MaterialColor.f_76363_);
        COLORS.put((Object)"red", (Object)MaterialColor.f_76364_);
        COLORS.put((Object)"black", (Object)MaterialColor.f_76365_);
        COLORS.put((Object)"gold", (Object)MaterialColor.f_76366_);
        COLORS.put((Object)"diamond", (Object)MaterialColor.f_76367_);
        COLORS.put((Object)"lapis", (Object)MaterialColor.f_76368_);
        COLORS.put((Object)"emerald", (Object)MaterialColor.f_76369_);
        COLORS.put((Object)"obsidian", (Object)MaterialColor.f_76370_);
        COLORS.put((Object)"netherrack", (Object)MaterialColor.f_76371_);
        COLORS.put((Object)"white_terracotta", (Object)MaterialColor.f_76372_);
        COLORS.put((Object)"orange_terracotta", (Object)MaterialColor.f_76373_);
        COLORS.put((Object)"magenta_terracotta", (Object)MaterialColor.f_76374_);
        COLORS.put((Object)"light_blue_terracotta", (Object)MaterialColor.f_76375_);
        COLORS.put((Object)"yellow_terracotta", (Object)MaterialColor.f_76376_);
        COLORS.put((Object)"lime_terracotta", (Object)MaterialColor.f_76377_);
        COLORS.put((Object)"pink_terracotta", (Object)MaterialColor.f_76378_);
        COLORS.put((Object)"gray_terracotta", (Object)MaterialColor.f_76379_);
        COLORS.put((Object)"light_gray_terracotta", (Object)MaterialColor.f_76380_);
        COLORS.put((Object)"cyan_terracotta", (Object)MaterialColor.f_76381_);
        COLORS.put((Object)"purple_terracotta", (Object)MaterialColor.f_76382_);
        COLORS.put((Object)"blue_terracotta", (Object)MaterialColor.f_76383_);
        COLORS.put((Object)"brown_terracotta", (Object)MaterialColor.f_76384_);
        COLORS.put((Object)"green_terracotta", (Object)MaterialColor.f_76385_);
        COLORS.put((Object)"red_terracotta", (Object)MaterialColor.f_76386_);
        COLORS.put((Object)"black_terracotta", (Object)MaterialColor.f_76388_);
        COLORS.put((Object)"crimson_nylium", (Object)MaterialColor.f_76389_);
        COLORS.put((Object)"crimson_stem", (Object)MaterialColor.f_76390_);
        COLORS.put((Object)"crimson_hyphae", (Object)MaterialColor.f_76391_);
        COLORS.put((Object)"warped_nylium", (Object)MaterialColor.f_76392_);
        COLORS.put((Object)"warped_stem", (Object)MaterialColor.f_76393_);
        COLORS.put((Object)"warped_hyphae", (Object)MaterialColor.f_76394_);
        COLORS.put((Object)"warped_wart", (Object)MaterialColor.f_76395_);
        COLORS.put((Object)"deepslate", (Object)MaterialColor.f_164534_);
        COLORS.put((Object)"raw_iron", (Object)MaterialColor.f_164535_);
        COLORS.put((Object)"glow_lichen", (Object)MaterialColor.f_164536_);
        COLORS_INV = COLORS.inverse();
    }
}

