/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.GhostIngredientHandler;
import com.simibubi.create.compat.jei.PotionFluidSubtypeInterpreter;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.CrushingCategory;
import com.simibubi.create.compat.jei.category.DeployingCategory;
import com.simibubi.create.compat.jei.category.FanBlastingCategory;
import com.simibubi.create.compat.jei.category.FanHauntingCategory;
import com.simibubi.create.compat.jei.category.FanSmokingCategory;
import com.simibubi.create.compat.jei.category.FanWashingCategory;
import com.simibubi.create.compat.jei.category.ItemApplicationCategory;
import com.simibubi.create.compat.jei.category.ItemDrainCategory;
import com.simibubi.create.compat.jei.category.MechanicalCraftingCategory;
import com.simibubi.create.compat.jei.category.MillingCategory;
import com.simibubi.create.compat.jei.category.MixingCategory;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.jei.category.PackingCategory;
import com.simibubi.create.compat.jei.category.PolishingCategory;
import com.simibubi.create.compat.jei.category.PressingCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.SawingCategory;
import com.simibubi.create.compat.jei.category.SequencedAssemblyCategory;
import com.simibubi.create.compat.jei.category.SpoutCategory;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipes;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.curiosities.tools.BlueprintScreen;
import com.simibubi.create.content.logistics.item.LinkedControllerScreen;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.data.recipe.LogStrippingFakeRecipes;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.ModList;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateJEI
implements IModPlugin {
    private static final ResourceLocation ID = Create.asResource("jei_plugin");
    public IIngredientManager ingredientManager;
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory milling = this.register("milling", MillingCategory::new).addTypedRecipes(AllRecipeTypes.MILLING).catalyst(AllBlocks.MILLSTONE::get).build();
        CreateRecipeCategory crushing = this.register("crushing", CrushingCategory::new).addTypedRecipes(AllRecipeTypes.CRUSHING).addTypedRecipesExcluding(AllRecipeTypes.MILLING::getType, AllRecipeTypes.CRUSHING::getType).catalyst(AllBlocks.CRUSHING_WHEEL::get).build();
        CreateRecipeCategory pressing = this.register("pressing", PressingCategory::new).addTypedRecipes(AllRecipeTypes.PRESSING).catalyst(AllBlocks.MECHANICAL_PRESS::get).build();
        CreateRecipeCategory washing = this.register("fan_washing", FanWashingCategory::new).addTypedRecipes(AllRecipeTypes.SPLASHING).catalystStack(ProcessingViaFanCategory.getFan("fan_washing")).build();
        CreateRecipeCategory smoking = this.register("fan_smoking", FanSmokingCategory::new).addTypedRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44110_).catalystStack(ProcessingViaFanCategory.getFan("fan_smoking")).build();
        CreateRecipeCategory blasting = this.register("fan_blasting", FanBlastingCategory::new).addTypedRecipesExcluding(() -> net.minecraft.world.item.crafting.RecipeType.f_44108_, () -> net.minecraft.world.item.crafting.RecipeType.f_44109_).addTypedRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44109_).removeRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44110_).catalystStack(ProcessingViaFanCategory.getFan("fan_blasting")).build();
        CreateRecipeCategory haunting = this.register("fan_haunting", FanHauntingCategory::new).addTypedRecipes(AllRecipeTypes.HAUNTING).catalystStack(ProcessingViaFanCategory.getFan("fan_haunting")).build();
        CreateRecipeCategory mixing = this.register("mixing", MixingCategory::standard).addTypedRecipes(AllRecipeTypes.MIXING).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
        CreateRecipeCategory seqAssembly = this.register("sequenced_assembly", SequencedAssemblyCategory::new).addTypedRecipes(AllRecipeTypes.SEQUENCED_ASSEMBLY).build();
        CreateRecipeCategory<BasinRecipe> autoShapeless = this.register("automatic_shapeless", MixingCategory::autoShapeless).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && r.m_7527_().size() > 1 && !MechanicalPressTileEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapelessInMixer).build();
        CreateRecipeCategory brewing = this.register("automatic_brewing", MixingCategory::autoBrewing).addRecipes(() -> PotionMixingRecipes.ALL).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
        CreateRecipeCategory sawing = this.register("sawing", SawingCategory::new).addTypedRecipes(AllRecipeTypes.CUTTING).catalyst(AllBlocks.MECHANICAL_SAW::get).build();
        CreateRecipeCategory blockCutting = this.register("block_cutting", () -> new BlockCuttingCategory(Items.f_42092_)).addRecipes(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType.f_44112_, AllRecipeTypes::shouldIgnoreInAutomation))).catalyst(AllBlocks.MECHANICAL_SAW::get).enableWhen(c -> c.allowStonecuttingOnSaw).build();
        CreateRecipeCategory woodCutting = this.register("wood_cutting", () -> new BlockCuttingCategory(Items.f_42008_)).addRecipes(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.getTypedRecipesExcluding(SawTileEntity.woodcuttingRecipeType.get(), AllRecipeTypes::shouldIgnoreInAutomation))).catalyst(AllBlocks.MECHANICAL_SAW::get).enableWhenBool(c -> (Boolean)c.allowWoodcuttingOnSaw.get() != false && ModList.get().isLoaded("druidcraft")).build();
        CreateRecipeCategory packing = this.register("packing", PackingCategory::standard).addTypedRecipes(AllRecipeTypes.COMPACTING).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).build();
        CreateRecipeCategory<BasinRecipe> autoSquare = this.register("automatic_packing", PackingCategory::autoSquare).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof MechanicalCraftingRecipe) && MechanicalPressTileEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapedSquareInPress).build();
        CreateRecipeCategory polishing = this.register("sandpaper_polishing", PolishingCategory::new).addTypedRecipes(AllRecipeTypes.SANDPAPER_POLISHING).catalyst(AllItems.SAND_PAPER::get).catalyst(AllItems.RED_SAND_PAPER::get).build();
        CreateRecipeCategory item_application = this.register("item_application", ItemApplicationCategory::new).addTypedRecipes(AllRecipeTypes.ITEM_APPLICATION).addRecipes(LogStrippingFakeRecipes::createRecipes).build();
        CreateRecipeCategory<DeployerApplicationRecipe> deploying = this.register("deploying", DeployingCategory::new).addTypedRecipes(AllRecipeTypes.DEPLOYING).addTypedRecipes(AllRecipeTypes.SANDPAPER_POLISHING::getType, DeployerApplicationRecipe::convert).addTypedRecipes(AllRecipeTypes.ITEM_APPLICATION::getType, ManualApplicationRecipe::asDeploying).catalyst(AllBlocks.DEPLOYER::get).catalyst(AllBlocks.DEPOT::get).catalyst(AllItems.BELT_CONNECTOR::get).build();
        CreateRecipeCategory mysteryConversion = this.register("mystery_conversion", MysteriousItemConversionCategory::new).addRecipes(() -> MysteriousItemConversionCategory.RECIPES).build();
        CreateRecipeCategory spoutFilling = this.register("spout_filling", SpoutCategory::new).addTypedRecipes(AllRecipeTypes.FILLING).addRecipeListConsumer(recipes -> SpoutCategory.consumeRecipes(recipes::add, this.ingredientManager)).catalyst(AllBlocks.SPOUT::get).build();
        CreateRecipeCategory draining = this.register("draining", ItemDrainCategory::new).addRecipeListConsumer(recipes -> ItemDrainCategory.consumeRecipes(recipes::add, this.ingredientManager)).addTypedRecipes(AllRecipeTypes.EMPTYING).catalyst(AllBlocks.ITEM_DRAIN::get).build();
        CreateRecipeCategory autoShaped = this.register("automatic_shaped", MechanicalCraftingCategory::new).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && r.m_7527_().size() == 1 && !AllRecipeTypes.shouldIgnoreInAutomation(r)).addTypedRecipesIf(() -> net.minecraft.world.item.crafting.RecipeType.f_44107_, recipe -> recipe instanceof IShapedRecipe && !AllRecipeTypes.shouldIgnoreInAutomation(recipe)).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).enableWhen(c -> c.allowRegularCraftingInCrafter).build();
        CreateRecipeCategory mechanicalCrafting = this.register("mechanical_crafting", MechanicalCraftingCategory::new).addTypedRecipes(AllRecipeTypes.MECHANICAL_CRAFTING).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).build();
    }

    private <T extends Recipe<?>> CategoryBuilder<T> register(String name, Supplier<CreateRecipeCategory<T>> supplier) {
        return new CategoryBuilder<T>(name, supplier);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerFluidSubtypes(ISubtypeRegistration registration) {
        PotionFluidSubtypeInterpreter interpreter = new PotionFluidSubtypeInterpreter();
        PotionFluid potionFluid = (PotionFluid)((Object)AllFluids.POTION.get());
        registration.registerSubtypeInterpreter(potionFluid.m_5613_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(potionFluid.m_5615_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxColoringRecipeMaker.createRecipes().toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.recipeCatalysts.forEach(s -> registration.addRecipeCatalyst((ItemStack)s.get(), new RecipeType[]{c.getRecipeType()})));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(LinkedControllerScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(ScheduleScreen.class, new GhostIngredientHandler());
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Minecraft.m_91087_().m_91403_().m_105141_().m_44051_().forEach(consumer);
    }

    public static <T extends Recipe<?>> void consumeTypedRecipes(Consumer<T> consumer, net.minecraft.world.item.crafting.RecipeType<?> type) {
        Map map = (Map)Minecraft.m_91087_().m_91403_().m_105141_().f_44007_.get(type);
        if (map != null) {
            map.values().forEach(recipe -> consumer.accept(recipe));
        }
    }

    public static List<Recipe<?>> getTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
        ArrayList recipes = new ArrayList();
        CreateJEI.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<Recipe<?>> getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPred) {
        List<Recipe<?>> recipes = CreateJEI.getTypedRecipes(type);
        recipes.removeIf(exclusionPred);
        return recipes;
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final CreateRecipeCategory<T> category;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private Predicate<CRecipes> predicate;

        public CategoryBuilder(String name, Supplier<CreateRecipeCategory<T>> category) {
            this.category = category.get();
            this.category.setCategoryId(name);
            RecipeType<T> recipeType = this.category.getRecipeType();
            this.predicate = cRecipes -> true;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(recipeTypeEntry::getType);
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get());
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.category.recipeCatalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> enableWhenBool(Function<CRecipes, Boolean> configValue) {
            this.predicate = configValue::apply;
            return this;
        }

        public CreateRecipeCategory<T> build() {
            if (this.predicate.test(AllConfigs.SERVER.recipes)) {
                this.category.recipes.add(() -> {
                    ArrayList recipes = new ArrayList();
                    for (Consumer consumer : this.recipeListConsumers) {
                        consumer.accept(recipes);
                    }
                    return recipes;
                });
            }
            CreateJEI.this.allCategories.add(this.category);
            return this.category;
        }
    }
}

