/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ControlledContraptionEntity
extends AbstractContraptionEntity {
    protected BlockPos controllerPos;
    protected Direction.Axis rotationAxis;
    protected float prevAngle;
    protected float angle;
    protected float angleDelta;

    public ControlledContraptionEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(Level world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity((EntityType)AllEntityTypes.CONTROLLED_CONTRAPTION.get(), world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public Vec3 getContactPointMotion(Vec3 globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.m_20184_();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption) {
            this.rotationAxis = ((BearingContraption)contraption).getFacing().m_122434_();
        }
    }

    @Override
    protected void readAdditional(CompoundTag compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        this.controllerPos = compound.m_128441_("Controller") ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller")) : NbtUtils.m_129239_((CompoundTag)compound.m_128469_("ControllerRelative")).m_141952_((Vec3i)this.m_142538_());
        if (compound.m_128441_("Axis")) {
            this.rotationAxis = NBTHelper.readEnum(compound, "Axis", Direction.Axis.class);
        }
        this.angle = compound.m_128457_("Angle");
    }

    @Override
    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.m_128365_("ControllerRelative", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos.m_141950_((Vec3i)this.m_142538_())));
        if (this.rotationAxis != null) {
            NBTHelper.writeEnum(compound, "Axis", this.rotationAxis);
        }
        compound.m_128350_("Angle", this.angle);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        if (this.rotationAxis == Direction.Axis.X) {
            crs.xRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Y) {
            crs.yRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Z) {
            crs.zRotation = this.angle;
        }
        return crs;
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0f ? this.angle : AngleHelper.angleLerp(partialTicks, this.prevAngle, this.angle);
    }

    public void setRotationAxis(Direction.Axis rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public Direction.Axis getRotationAxis() {
        return this.rotationAxis;
    }

    public void m_6021_(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void tickContraption() {
        this.angleDelta = this.angle - this.prevAngle;
        this.prevAngle = this.angle;
        this.tickActors();
        if (this.controllerPos == null) {
            return;
        }
        if (!this.f_19853_.m_46749_(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.m_146870_();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (this.f_19853_.f_46443_) {
                this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    @Override
    protected boolean shouldActorTrigger(MovementContext context, StructureTemplate.StructureBlockInfo blockInfo, MovementBehaviour actor, Vec3 actorPosition, BlockPos gridPosition) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition)) {
            return true;
        }
        if (!(this.contraption instanceof BearingContraption)) {
            return false;
        }
        BearingContraption bc = (BearingContraption)this.contraption;
        Direction facing = bc.getFacing();
        Vec3 activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.m_82559_(VecHelper.axisAlingedPlaneOf(Vec3.m_82528_((Vec3i)facing.m_122436_()))).equals((Object)Vec3.f_82478_)) {
            return false;
        }
        if (!VecHelper.onSameAxis(blockInfo.f_74675_, BlockPos.f_121853_, facing.m_122434_())) {
            return false;
        }
        context.relativeMotion = context.motion = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_((double)this.angleDelta / 360.0);
        int timer = context.data.m_128451_("StationaryTimer");
        if (timer > 0) {
            context.data.m_128405_("StationaryTimer", timer - 1);
            return false;
        }
        context.data.m_128405_("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.f_19853_.m_46749_(this.controllerPos)) {
            return null;
        }
        BlockEntity te = this.f_19853_.m_7702_(this.controllerPos);
        if (!(te instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)te;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = new BlockPos(this.getAnchorVec().m_82520_(0.5, 0.5, 0.5));
        float xRot = this.rotationAxis == Direction.Axis.X ? this.angle : 0.0f;
        float yRot = this.rotationAxis == Direction.Axis.Y ? this.angle : 0.0f;
        float zRot = this.rotationAxis == Direction.Axis.Z ? this.angle : 0.0f;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return this.angle;
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.m_20343_(x, y, z);
        this.angle = this.prevAngle = angle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doLocalTransforms(float partialTicks, PoseStack[] matrixStacks) {
        float angle = this.getAngle(partialTicks);
        Direction.Axis axis = this.getRotationAxis();
        for (PoseStack stack : matrixStacks) {
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)stack).nudge(this.m_142049_())).centre()).rotate((double)angle, axis)).unCentre();
        }
    }
}

