/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPulleyRenderer
extends KineticTileEntityRenderer {
    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(BlockEntityRendererProvider.Context context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean shouldRenderOffScreen(KineticTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(te, partialTicks);
        boolean running = this.isRunning(te);
        Direction.Axis rotationAxis = ((IRotate)te.m_58900_().m_60734_()).getRotationAxis(te.m_58900_());
        AbstractPulleyRenderer.kineticRotationTransform(this.getRotatedCoil(te), te, rotationAxis, AngleHelper.rad(offset * 180.0f), light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        Level world = te.m_58904_();
        BlockState blockState = te.m_58900_();
        BlockPos pos = te.m_58899_();
        SuperByteBuffer halfMagnet = CachedBufferer.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBufferer.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = this.renderMagnet(te);
        SuperByteBuffer rope = this.renderRope(te);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        if (running || offset == 0.0f) {
            this.renderAt((LevelAccessor)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            this.renderAt((LevelAccessor)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            this.renderAt((LevelAccessor)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    private void renderAt(LevelAccessor world, SuperByteBuffer partial, float offset, BlockPos pulleyPos, PoseStack ms, VertexConsumer buffer) {
        BlockPos actualPos = pulleyPos.m_6625_((int)offset);
        int light = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)world.m_8055_(actualPos), (BlockPos)actualPos);
        partial.translate(0.0, -offset, 0.0).light(light).renderInto(ms, buffer);
    }

    protected abstract Direction.Axis getShaftAxis(KineticTileEntity var1);

    protected abstract PartialModel getCoil();

    protected abstract SuperByteBuffer renderRope(KineticTileEntity var1);

    protected abstract SuperByteBuffer renderMagnet(KineticTileEntity var1);

    protected abstract float getOffset(KineticTileEntity var1, float var2);

    protected abstract boolean isRunning(KineticTileEntity var1);

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(te));
    }

    protected SuperByteBuffer getRotatedCoil(KineticTileEntity te) {
        BlockState blockState = te.m_58900_();
        return CachedBufferer.partialFacing(this.getCoil(), blockState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getShaftAxis(te)));
    }

    public int m_142163_() {
        return 256;
    }
}

