/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.girder;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.girder.GirderBlock;
import com.simibubi.create.content.curiosities.girder.GirderCTBehaviour;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConnectedGirderModel
extends CTModel {
    protected static ModelProperty<ConnectionData> CONNECTION_PROPERTY = new ModelProperty();

    public ConnectedGirderModel(BakedModel originalModel) {
        super(originalModel, new GirderCTBehaviour());
    }

    @Override
    protected ModelDataMap.Builder gatherModelData(ModelDataMap.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        ConnectionData connectionData = new ConnectionData();
        for (Direction d : Iterate.horizontalDirections) {
            connectionData.setConnected(d, GirderBlock.isConnected(world, pos, state, d));
        }
        return super.gatherModelData(builder, world, pos, state).withInitial(CONNECTION_PROPERTY, (Object)connectionData);
    }

    @Override
    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        List<BakedQuad> superQuads = super.getQuads(state, side, rand, extraData);
        if (side != null || !extraData.hasProperty(CONNECTION_PROPERTY)) {
            return superQuads;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(superQuads);
        ConnectionData data = (ConnectionData)extraData.getData(CONNECTION_PROPERTY);
        for (Direction d : Iterate.horizontalDirections) {
            if (!data.isConnected(d)) continue;
            quads.addAll(AllBlockPartials.METAL_GIRDER_BRACKETS.get(d).get().getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    private class ConnectionData {
        boolean[] connectedFaces = new boolean[4];

        public ConnectionData() {
            Arrays.fill(this.connectedFaces, false);
        }

        void setConnected(Direction face, boolean connected) {
            this.connectedFaces[face.m_122416_()] = connected;
        }

        boolean isConnected(Direction face) {
            return this.connectedFaces[face.m_122416_()];
        }
    }
}

