/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.contraptions.fluids.tank.BoilerData;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;

public class BoilerDisplaySource
extends DisplaySource {
    public static final List<MutableComponent> notEnoughSpaceSingle = List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0]).m_7220_((Component)Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0])));
    public static final List<MutableComponent> notEnoughSpaceDouble = List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0]), Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0]));
    public static final List<List<MutableComponent>> notEnoughSpaceFlap = List.of(List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0])), List.of(Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0])));

    @Override
    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return notEnoughSpaceSingle;
        }
        if (stats.maxRows() < 4) {
            return notEnoughSpaceDouble;
        }
        boolean isBook = context.getTargetTE() instanceof LecternBlockEntity;
        if (isBook) {
            Stream<MutableComponent> componentList = this.getComponents(context, false).map(components -> {
                Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
                return reduce.orElse(EMPTY_LINE);
            });
            return List.of(componentList.reduce((comp1, comp2) -> comp1.m_7220_((Component)new TextComponent("\n")).m_7220_((Component)comp2)).orElse(EMPTY_LINE));
        }
        return this.getComponents(context, false).map(components -> {
            Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
            return reduce.orElse(EMPTY_LINE);
        }).toList();
    }

    @Override
    public List<List<MutableComponent>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 4) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        List<List<MutableComponent>> components = this.getComponents(context, true).toList();
        if ((float)stats.maxColumns() * 7.0f < 42.0f + (float)components.get(1).get(1).getString().length() * 9.0f) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        return components;
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        Boolean b;
        Object object;
        if (lineIndex == 0 || (object = context.flapDisplayContext) instanceof Boolean && !(b = (Boolean)object).booleanValue()) {
            if (layout.isLayout("Default")) {
                return;
            }
            layout.loadDefault(flapDisplay.getMaxCharCount());
            return;
        }
        String layoutKey = "Boiler";
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int labelLength = (int)((float)this.labelWidth() * 7.0f);
        float maxSpace = (float)flapDisplay.getMaxCharCount(1) * 7.0f;
        FlapDisplaySection label = new FlapDisplaySection(labelLength, "alphabet", false, true);
        FlapDisplaySection symbols = new FlapDisplaySection(maxSpace - (float)labelLength, "pixel", false, false).wideFlaps();
        layout.configure(layoutKey, List.of(label, symbols));
    }

    private Stream<List<MutableComponent>> getComponents(DisplayLinkContext context, boolean forFlapDisplay) {
        BlockEntity sourceTE = context.getSourceTE();
        if (!(sourceTE instanceof FluidTankTileEntity)) {
            return Stream.of(EMPTY);
        }
        FluidTankTileEntity tankTile = (FluidTankTileEntity)sourceTE;
        tankTile = tankTile.getControllerTE();
        if (tankTile == null) {
            return Stream.of(EMPTY);
        }
        BoilerData boiler = tankTile.boiler;
        int totalTankSize = tankTile.getTotalTankSize();
        boiler.calcMinMaxForSize(totalTankSize);
        String label = forFlapDisplay ? "boiler.status" : "boiler.status_short";
        MutableComponent size = this.labelOf(forFlapDisplay ? "size" : "");
        MutableComponent water = this.labelOf(forFlapDisplay ? "water" : "");
        MutableComponent heat = this.labelOf(forFlapDisplay ? "heat" : "");
        int lw = this.labelWidth();
        if (forFlapDisplay) {
            size = new TextComponent(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("size")))).m_7220_((Component)size);
            water = new TextComponent(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("water")))).m_7220_((Component)water);
            heat = new TextComponent(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("heat")))).m_7220_((Component)heat);
        }
        return Stream.of(List.of(Lang.translateDirect(label, boiler.getHeatLevelTextComponent())), List.of(size, boiler.getSizeComponent(!forFlapDisplay, forFlapDisplay, ChatFormatting.BLACK)), List.of(water, boiler.getWaterComponent(!forFlapDisplay, forFlapDisplay, ChatFormatting.BLACK)), List.of(heat, boiler.getHeatComponent(!forFlapDisplay, forFlapDisplay, ChatFormatting.BLACK)));
    }

    private int labelWidth() {
        return Math.max(this.labelWidthOf("water"), Math.max(this.labelWidthOf("size"), this.labelWidthOf("heat")));
    }

    private int labelWidthOf(String label) {
        return this.labelOf(label).getString().length();
    }

    private MutableComponent labelOf(String label) {
        if (label.isBlank()) {
            return TextComponent.f_131282_.m_6881_();
        }
        return Lang.translateDirect("boiler." + label, new Object[0]);
    }

    @Override
    protected String getTranslationKey() {
        return "boiler_status";
    }
}

