/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.jozufozu.flywheel.api.MaterialManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public interface IBogeyBlock
extends IWrenchable {
    public static final List<ResourceLocation> BOGEYS = new ArrayList<ResourceLocation>();

    public static void register(ResourceLocation block) {
        BOGEYS.add(block);
    }

    public EnumSet<Direction> getStickySurfaces(BlockGetter var1, BlockPos var2, BlockState var3);

    public double getWheelPointSpacing();

    public double getWheelRadius();

    public boolean allowsSingleBogeyCarriage();

    public Vec3 getConnectorAnchorOffset();

    @OnlyIn(value=Dist.CLIENT)
    public void render(@Nullable BlockState var1, float var2, PoseStack var3, float var4, MultiBufferSource var5, int var6, int var7);

    @OnlyIn(value=Dist.CLIENT)
    public BogeyInstance createInstance(MaterialManager var1, CarriageBogey var2);

    default public Direction getBogeyUpDirection() {
        return Direction.UP;
    }

    public boolean isTrackAxisAlongFirstCoordinate(BlockState var1);

    @Nullable
    public BlockState getMatchingBogey(Direction var1, boolean var2);

    @Override
    default public BlockState getRotatedBlockState(BlockState state, Direction targetedFace) {
        Block block = state.m_60734_();
        int indexOf = BOGEYS.indexOf(block.getRegistryName());
        if (indexOf == -1) {
            return state;
        }
        int index = (indexOf + 1) % BOGEYS.size();
        Direction bogeyUpDirection = this.getBogeyUpDirection();
        boolean trackAxisAlongFirstCoordinate = this.isTrackAxisAlongFirstCoordinate(state);
        while (index != indexOf) {
            IBogeyBlock bogey;
            BlockState matchingBogey;
            ResourceLocation id = BOGEYS.get(index);
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (newBlock instanceof IBogeyBlock && (matchingBogey = (bogey = (IBogeyBlock)newBlock).getMatchingBogey(bogeyUpDirection, trackAxisAlongFirstCoordinate)) != null) {
                return matchingBogey.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)matchingBogey.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))) : matchingBogey;
            }
            index = (index + 1) % BOGEYS.size();
        }
        return state;
    }
}

