/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.api.event.TileEntityBehaviourEvent;
import com.simibubi.create.content.schematics.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.tileEntity.CachedRenderBBTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class SmartTileEntity
extends CachedRenderBBTileEntity
implements IPartialSafeNBT,
IInteractionChecker,
ISpecialBlockEntityItemRequirement {
    private final Map<BehaviourType<?>, TileEntityBehaviour> behaviours = new HashMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean virtualMode;
    private boolean unloaded;

    public SmartTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<TileEntityBehaviour> var1);

    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
    }

    public void initialize() {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            MinecraftForge.EVENT_BUS.post(new TileEntityBehaviourEvent<SmartTileEntity>(this, this.behaviours));
        }
        this.forEachBehaviour(TileEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.m_58898_()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(TileEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.m_183515_(tag);
        this.forEachBehaviour(tb -> tb.write(tag, clientPacket));
    }

    @Override
    public void writeSafe(CompoundTag tag, boolean clientPacket) {
        super.m_183515_(tag);
        this.forEachBehaviour(tb -> {
            if (tb.isSafeNBT()) {
                tb.write(tag, clientPacket);
            }
        });
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
            MinecraftForge.EVENT_BUS.post(new TileEntityBehaviourEvent<SmartTileEntity>(this, this.behaviours));
        }
        super.m_142466_(tag);
        this.forEachBehaviour(tb -> tb.read(tag, clientPacket));
    }

    public final void m_142466_(CompoundTag tag) {
        this.read(tag, false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    protected void setRemovedNotDueToChunkUnload() {
        this.forEachBehaviour(TileEntityBehaviour::remove);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.unloaded) {
            this.setRemovedNotDueToChunkUnload();
        }
    }

    public final void m_183515_(CompoundTag tag) {
        this.write(tag, false);
    }

    @Override
    public final void readClient(CompoundTag tag) {
        this.read(tag, true);
    }

    @Override
    public final CompoundTag writeClient(CompoundTag tag) {
        this.write(tag, true);
        return tag;
    }

    public <T extends TileEntityBehaviour> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    protected void forEachBehaviour(Consumer<TileEntityBehaviour> action) {
        this.behaviours.values().forEach(action);
    }

    protected void attachBehaviourLate(TileEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.initialize();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        return this.behaviours.values().stream().reduce(ItemRequirement.NONE, (r, b) -> r.union(b.getRequiredItems()), (r, r1) -> r.union((ItemRequirement)r1));
    }

    protected void removeBehaviour(BehaviourType<?> type) {
        TileEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.remove();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void markVirtual() {
        this.virtualMode = true;
    }

    public boolean isVirtual() {
        return this.virtualMode;
    }

    @Override
    public boolean canPlayerUse(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void sendToContainer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.m_58899_());
        buffer.m_130079_(this.m_5995_());
    }

    public void refreshBlockState() {
        this.m_155250_(this.m_58904_().m_8055_(this.m_58899_()));
    }

    protected boolean isItemHandlerCap(Capability<?> cap) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    protected boolean isFluidHandlerCap(Capability<?> cap) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public void registerAwardables(List<TileEntityBehaviour> behaviours, CreateAdvancement ... advancements) {
        for (TileEntityBehaviour behaviour : behaviours) {
            if (!(behaviour instanceof AdvancementBehaviour)) continue;
            AdvancementBehaviour ab = (AdvancementBehaviour)behaviour;
            ab.add(advancements);
            return;
        }
        behaviours.add(new AdvancementBehaviour(this, advancements));
    }

    public void award(CreateAdvancement advancement) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public void awardIfNear(CreateAdvancement advancement, int range) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayerIfNear(advancement, range);
        }
    }
}

