/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(Level world, BlockPos pos, IDrawerGroup group) {
        block0: for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            while (drawer.getStoredItemCount() > 0) {
                ItemStack stack = drawer.getStoredItemPrototype().m_41777_();
                int storedCount = drawer.getStoredItemCount();
                int stackLimit = stack.m_41741_();
                int stackSize = Math.min(storedCount, stackLimit);
                stack.m_41764_(stackSize);
                if (stack.m_41619_()) continue block0;
                DrawerInventoryHelper.spawnItemStack(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
                drawer.adjustStoredItemCount(-stackSize);
            }
        }
    }

    private static void spawnItemStack(Level world, double x, double y, double z, ItemStack stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.m_41619_()) {
            ItemEntity entityitem = new ItemEntity(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, stack.m_41620_(RANDOM.nextInt(21) + 10));
            float velocity = 0.05f;
            entityitem.m_20334_(RANDOM.nextGaussian() * (double)velocity, RANDOM.nextGaussian() * (double)velocity + (double)0.2f, RANDOM.nextGaussian() * (double)velocity);
            world.m_7967_((Entity)entityitem);
        }
    }
}

