/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;
import snownee.kiwi.mixin.ShapedRecipeAccess;

public abstract class DynamicShapedRecipe
extends CustomRecipe
implements IShapedRecipe<CraftingContainer> {
    private int width;
    private int height;
    private NonNullList<Ingredient> recipeItems;
    public String pattern;
    public boolean differentInputs;
    public ItemStack recipeOutput;
    private String group;

    public DynamicShapedRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.search(inv) != null;
    }

    @Nullable
    public int[] search(CraftingContainer inv) {
        for (int x = 0; x <= inv.m_39347_() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.m_39346_() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y) || !this.checkEmpty(inv, x, y)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public ItemStack item(char key, CraftingContainer inv, int[] matchPos) {
        int i = this.pattern.indexOf(key);
        if (i != -1) {
            int x = matchPos[0] + i % this.width;
            int y = matchPos[1] + i / this.width;
            return inv.m_8020_(x + y * inv.m_39347_());
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> items(char key, CraftingContainer inv, int[] matchPos) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < this.pattern.length(); ++i) {
            if (key != this.pattern.charAt(i)) continue;
            int x = matchPos[0] + i % this.width;
            int y = matchPos[1] + i / this.width;
            items.add(inv.m_8020_(x + y * inv.m_39347_()));
        }
        return items;
    }

    public abstract ItemStack assemble(CraftingContainer var1);

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.getRecipeWidth() && height >= this.getRecipeHeight();
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public abstract RecipeSerializer<?> m_7707_();

    protected boolean checkMatch(CraftingContainer inv, int startX, int startY) {
        Char2ObjectArrayMap ingredientsArrayMap = null;
        if (!this.differentInputs) {
            ingredientsArrayMap = new Char2ObjectArrayMap();
        }
        for (int y = startY; y < startY + this.getRecipeHeight(); ++y) {
            for (int x = startX; x < startX + this.getRecipeWidth(); ++x) {
                int i;
                char key;
                int rx = x - startX;
                int ry = y - startY;
                if (!this.matches(inv, x, y, rx, ry)) {
                    return false;
                }
                if (this.differentInputs || (key = this.pattern.charAt(i = rx + ry * this.getRecipeWidth())) == ' ') continue;
                ItemStack stack0 = inv.m_8020_(x + y * inv.m_39347_());
                ItemStack stack1 = (ItemStack)ingredientsArrayMap.get(key);
                if (stack1 == null) {
                    ingredientsArrayMap.put(key, (Object)stack0);
                    continue;
                }
                if (stack1.m_41726_(stack0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(CraftingContainer inv, int x, int y, int rx, int ry) {
        Ingredient ingredient = (Ingredient)this.recipeItems.get(rx + ry * this.getRecipeWidth());
        return ingredient.test(inv.m_8020_(x + y * inv.m_39347_()));
    }

    protected boolean checkEmpty(CraftingContainer inv, int startX, int startY) {
        for (int y = 0; y < inv.m_39346_(); ++y) {
            int subY = y - startY;
            for (int x = 0; x < inv.m_39347_(); ++x) {
                int subX = x - startX;
                if (subX >= 0 && subY >= 0 && subX < this.getRecipeWidth() && subY < this.getRecipeHeight() || this.getEmpty().test(inv.m_8020_(x + y * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    protected Predicate<ItemStack> getEmpty() {
        return Ingredient.f_43901_;
    }

    public static abstract class Serializer<T extends DynamicShapedRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        public static void fromJson(DynamicShapedRecipe recipe, JsonObject json) {
            recipe.group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> ingredientMap = ShapedRecipeAccess.callKeyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            CharSequence[] pattern = ShapedRecipeAccess.callShrink(ShapedRecipeAccess.callPatternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            recipe.pattern = String.join((CharSequence)"", pattern);
            recipe.width = ((String)pattern[0]).length();
            recipe.height = pattern.length;
            recipe.recipeItems = ShapedRecipeAccess.callDissolvePattern((String[])pattern, ingredientMap, recipe.width, recipe.height);
            recipe.recipeOutput = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            recipe.differentInputs = GsonHelper.m_13855_((JsonObject)json, (String)"differentInputs", (boolean)false);
        }

        public static void fromNetwork(DynamicShapedRecipe recipe, FriendlyByteBuf buffer) {
            recipe.width = buffer.m_130242_();
            recipe.height = buffer.m_130242_();
            recipe.group = buffer.m_130136_(256);
            int size = recipe.width * recipe.height;
            recipe.recipeItems = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int k = 0; k < size; ++k) {
                recipe.recipeItems.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            recipe.recipeOutput = buffer.m_130267_();
            recipe.pattern = buffer.m_130136_(size);
            recipe.differentInputs = buffer.readBoolean();
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130130_(((DynamicShapedRecipe)((Object)recipe)).getRecipeWidth());
            buffer.m_130130_(((DynamicShapedRecipe)((Object)recipe)).getRecipeHeight());
            buffer.m_130072_(((DynamicShapedRecipe)((Object)recipe)).m_6076_(), 256);
            for (Ingredient ingredient : ((DynamicShapedRecipe)((Object)recipe)).m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(((DynamicShapedRecipe)((Object)recipe)).recipeOutput);
            buffer.m_130072_(((DynamicShapedRecipe)((Object)recipe)).pattern, ((DynamicShapedRecipe)((Object)recipe)).m_7527_().size());
            buffer.writeBoolean(((DynamicShapedRecipe)((Object)recipe)).differentInputs);
        }
    }
}

